package cn.benguo.xm.push.route.action;

import android.content.Context;
import android.text.TextUtils;

import com.spinytech.macore.MaActionResult;
import com.xiaomi.mipush.sdk.MiPushClient;

import java.util.HashMap;
import java.util.Iterator;

import cn.benguo.xm.push.cache.RegIdCache;

/**
 * 小米的设置标签，是通过setUserAccount的方式
 * Created by pyt on 2017/3/24.
 */

public class OnSetTagAction extends BaseAction {

    @Override
    public MaActionResult invoke(Context context, HashMap<String, String> requestData) {
        log(requestData.toString());
        String regId = RegIdCache.getRegId(context.getApplicationContext());
        if (TextUtils.isEmpty(regId)) {
            throw new IllegalStateException("mi push is not register success,call userAccount Method when you register success");
        }

        if (requestData.isEmpty()) {
            throw new IllegalStateException("current tags is null,please check it!");
        }
        Iterator<String> iterator = requestData.keySet().iterator();
        while (iterator.hasNext()) {
            String next = iterator.next();
            MiPushClient.subscribe(context.getApplicationContext(),next,null);
        }
        return getCommonSuccessResult();
    }
}
