package cn.benguo.xm.push.route.action;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.util.Log;

import com.spinytech.macore.MaActionResult;
import com.xiaomi.mipush.sdk.MiPushClient;

import java.util.HashMap;

/**
 * Created by pyt on 2017/3/24.
 */

public class OnRegisterAction extends BaseAction {
    private static final String TAG = "OnRegisterAction_XIAOMI";


    public static final String MI_PUSH_APP_ID = "MI_PUSH_APP_ID";

    public static final String MI_PUSH_APP_KEY = "MI_PUSH_APP_KEY";

    @Override
    public boolean isAsync(Context context, HashMap<String, String> requestData) {
        return false;
    }

    @Override
    public MaActionResult invoke(Context context, HashMap<String, String> requestData) {
        log(requestData.toString());

        Log.i(TAG, "小米平台注册");
        //获取Manifest中Application节点下小米推送的appid和appkey
        try {
            ApplicationInfo applicationInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), PackageManager.GET_META_DATA);
            Bundle metaData = applicationInfo.metaData;
            String appId = metaData.getString(MI_PUSH_APP_ID);
            String appKey = metaData.getString(MI_PUSH_APP_KEY);
            Log.e(TAG,"小米appid: " + appId + "  appKey:  " + appKey+"  bundle"+metaData.toString());
            MiPushClient.registerPush(context.getApplicationContext(),appId,appKey);



        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return getCommonSuccessResult();
    }
}
