package cn.benguo.xm.push.route.action;

import android.content.Context;

import com.spinytech.macore.MaActionResult;
import com.xiaomi.mipush.sdk.MiPushClient;

import java.util.HashMap;
import java.util.Iterator;

import cn.benguo.core.push.RouteOperator;

/**
 * Created by pyt on 2017/3/24.
 */

public class OnDeleteTagAction extends BaseAction {
    @Override
    public boolean isAsync(Context context, HashMap<String, String> requestData) {
        return false;
    }

    @Override
    public MaActionResult invoke(Context context, HashMap<String, String> requestData) {
        log(requestData.toString());

        if (requestData.isEmpty()) {
            throw new IllegalStateException("current tags is null,please check it!");
        }
        Iterator<String> iterator = requestData.keySet().iterator();
        while (iterator.hasNext()) {
            String next = iterator.next();
            if (MiPushClient.topicSubscribedTime(context.getApplicationContext(), next) < 0L) {
                RouteOperator.receiveCommandResult(context, "20002", "-1", next,"Don't cancel tag for ["+next+"] is unseted");
            } else {
                MiPushClient.unsubscribe(context.getApplicationContext(),next,null);
            }


        }
        return getCommonSuccessResult();
    }
}
