package cn.benguo.xm.push.route.action;


import android.content.Context;
import android.text.TextUtils;

import com.spinytech.macore.MaActionResult;
import com.xiaomi.mipush.sdk.MiPushClient;

import java.util.HashMap;

import cn.benguo.xm.push.cache.RegIdCache;

/**
 * 小米的绑定账号指的 绑定setAlias(别名的方式)
 * Created by pyt on 2017/3/27.
 */

public class OnBindAccountAction extends BaseAction {


    @Override
    public MaActionResult invoke(Context context, HashMap<String, String> requestData) {
        log(requestData.toString());
        String account = requestData.get("account");
        String regId = RegIdCache.getRegId(context.getApplicationContext());
        if (TextUtils.isEmpty(regId)) {
            throw new IllegalStateException("mi push is not register success,set alias when you register success");
        }
        MiPushClient.setAlias(context.getApplicationContext(), account, null);
        return getCommonSuccessResult();
    }

}
