package cn.benguo.xm.push.cache;

import android.content.Context;
import android.content.SharedPreferences;

/**
 * 小米的regID缓存的区
 *
 * Created by pyt on 2017/3/27.
 */

public class RegIdCache {

    static final String SHARE_FILE_NAME = "mi_push";
    static final String MI_PUSH_REGID = "mi_push_regid";

    public static void saveRegId(Context context,String regId){
        SharedPreferences sharedPreferences = context.getSharedPreferences(SHARE_FILE_NAME, Context.MODE_PRIVATE);
        sharedPreferences.edit().putString(MI_PUSH_REGID, regId).commit();
    }

    public static String getRegId(Context context){
        return context.getSharedPreferences(SHARE_FILE_NAME, Context.MODE_PRIVATE).getString(MI_PUSH_REGID, null);
    }


    public static void clear(Context context){
        context.getSharedPreferences(SHARE_FILE_NAME, Context.MODE_PRIVATE).edit().clear().commit();
    }


}
