package cn.benguo.xg.push.route.action;

import android.content.Context;

import com.spinytech.macore.MaActionResult;
import com.spinytech.macore.MaApplication;
import com.spinytech.macore.router.LocalRouter;
import com.spinytech.macore.router.RouterRequest;
import com.tencent.android.tpush.XGIOperateCallback;
import com.tencent.android.tpush.XGPushManager;

import java.util.HashMap;

/**
 * Created by pyt on 2017/3/27.
 */

public class OnUnBindAccountAction extends BaseAction {
    @Override
    public MaActionResult invoke(final Context context, HashMap<String, String> requestData) {
        XGPushManager.registerPush(context.getApplicationContext(), "*", new XGIOperateCallback() {
            @Override
            public void onSuccess(Object token, int flag) {
                onUnbindAccountResult(context,"0");
            }

            @Override
            public void onFail(Object token, int errCode, String msg) {
                onUnbindAccountResult(context,"-1");
            }
        });
        return getCommonSuccessResult();
    }

    private void onUnbindAccountResult(Context context, String resultCode) {
        try {
            LocalRouter.getInstance(MaApplication.getMaApplication()).route(context.getApplicationContext(), RouterRequest.obtain(context.getApplicationContext())
                            .action("receive_command_result")
                            //相关code详见#PushCommandCode
                            .data("type","20005")
                            .data("result_code",resultCode));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

}
