package cn.benguo.xg.push.route.action;

import android.content.Context;
import android.util.Log;

import com.spinytech.macore.MaActionResult;
import com.tencent.android.tpush.XGIOperateCallback;
import com.tencent.android.tpush.XGNotifaction;
import com.tencent.android.tpush.XGPushConfig;
import com.tencent.android.tpush.XGPushManager;
import com.tencent.android.tpush.XGPushNotifactionCallback;
import com.tencent.android.tpush.common.Constants;

import java.lang.reflect.Field;
import java.util.HashMap;


/**
 * Created by pyt on 2017/3/24.
 */

public class OnRegisterAction extends BaseAction {
    private static final String TAG = "OnRegisterAction";

    @Override
    public MaActionResult invoke(Context context, HashMap<String, String> requestData) {
        Log.i(TAG, "信鸽平台注册");

        XGPushManager.registerPush(context.getApplicationContext(), new XGIOperateCallback() {
            @Override
            public void onSuccess(Object token, int flag) {
                Log.w(Constants.LogTag,
                        "+++ register push sucess. token:" + token);
            }

            @Override
            public void onFail(Object token, int errCode, String msg) {
                Log.w(Constants.LogTag,
                        "+++ register push fail. token:" + token
                                + ", errCode:" + errCode + ",msg:"
                                + msg);
            }
        });

        XGPushManager.setNotifactionCallback(new XGPushNotifactionCallback() {
            @Override
            public void handleNotify(XGNotifaction xgNotifaction) {

                xgNotifaction.doNotify();
            }
        });

        //TODO:设置默认的样式，统一所有的信鸽推送的样式,在部分手机上显示的有点奇怪，需要修改一下显示

        return getCommonSuccessResult();
    }

}
