package cn.benguo.xg.push;

import android.content.Context;
import android.util.Log;

import com.tencent.android.tpush.XGPushBaseReceiver;
import com.tencent.android.tpush.XGPushClickedResult;
import com.tencent.android.tpush.XGPushRegisterResult;
import com.tencent.android.tpush.XGPushShowedResult;
import com.tencent.android.tpush.XGPushTextMessage;

import cn.benguo.core.push.RouteOperator;

/**
 * 信鸽推送服务，通知和消息的广播接收器
 * <p>
 * Created by pyt on 2017/3/23.
 */

public class XinGePushReceiver extends XGPushBaseReceiver {

    private static final String TAG = "XinGePushReceiver";

    // 通知展示
    @Override
    public void onNotifactionShowedResult(Context context, XGPushShowedResult notifiShowedRlt) {
        Log.d(TAG, "onNotifactionShowedResult() called with: context = [" + context + "], notifiShowedRlt = [" + notifiShowedRlt + "]");
        RouteOperator.receiveNotification(context, String.valueOf(notifiShowedRlt.getNotifactionId()), notifiShowedRlt.getTitle(), notifiShowedRlt.getContent(), notifiShowedRlt.getCustomContent(), "");

    }


    // 通知点击回调 actionType=1为该消息被清除，actionType=0为该消息被点击
    @Override
    public void onNotifactionClickedResult(Context context,XGPushClickedResult message) {
        Log.d(TAG, "onNotifactionClickedResult() called with: context = [" + context + "], message = [" + message + "]");
        if (context == null || message == null) {
            return;
        }
        if (message.getActionType() == XGPushClickedResult.NOTIFACTION_CLICKED_TYPE) {
            // 通知在通知栏被点击啦。。。。。
            // APP自己处理点击的相关动作
            // 这个动作可以在activity的onResume也能监听，请看第3点相关内容
            RouteOperator.receiveNotificationClick(context, "0", message.getTitle(), message.getContent(), message.getCustomContent(), null);
        } else if (message.getActionType() == XGPushClickedResult.NOTIFACTION_DELETED_TYPE) {
            // 通知被清除啦。。。。
            // APP自己处理通知被清除后的相关动作
        }
    }

    // 消息透传
    @Override
    public void onTextMessage(Context context, XGPushTextMessage message) {
        Log.d(TAG, "onTextMessage() called with: context = [" + context + "], message = [" + message + "]");
        RouteOperator.receiveMessage(context,message.getTitle(),message.getContent(),message.getCustomContent(),null);
    }

    @Override
    public void onUnregisterResult(Context context, int errorCode) {
        Log.d(TAG, "onUnregisterResult() called with: context = [" + context + "], errorCode = [" + errorCode + "]");
        if (context == null) {
            return;
        }

        RouteOperator.receiveCommandResult(context,"20003",errorCode==XinGePushReceiver.SUCCESS?"0":String.valueOf(errorCode),null,
                errorCode==XinGePushReceiver.SUCCESS?null:"onUnregisterResult failure!");
    }

    @Override
    public void onSetTagResult(Context context, int errorCode, String tagName) {
        Log.d(TAG, "onSetTagResult() called with: context = [" + context + "], errorCode = [" + errorCode + "], tagName = [" + tagName + "]");
        if (context == null) {
            return;
        }

        RouteOperator.receiveCommandResult(context,"20001",errorCode==XinGePushReceiver.SUCCESS?"0":String.valueOf(errorCode),null,
                errorCode==XinGePushReceiver.SUCCESS?null:"onSetTagResult failure!");


    }

    @Override
    public void onDeleteTagResult(Context context, int errorCode, String tagName) {
        Log.d(TAG, "onDeleteTagResult() called with: context = [" + context + "], errorCode = [" + errorCode + "], tagName = [" + tagName + "]");
        if (context == null) {
            return;
        }

        RouteOperator.receiveCommandResult(context,"20002",errorCode==XinGePushReceiver.SUCCESS?"0":String.valueOf(errorCode),null,
                errorCode==XinGePushReceiver.SUCCESS?null:"onDeleteTagResult failure!");

    }



    @Override
    public void onRegisterResult(Context context, int errorCode,
                                 XGPushRegisterResult message) {
        Log.d(TAG, "onRegisterResult() called with: context = [" + context + "], errorCode = [" + errorCode + "], message = [" + message + "]");
        if (context == null || message == null) {
            return;
        }
        RouteOperator.receiveRegisterResult(context, errorCode == XinGePushReceiver.SUCCESS ? "0" : String.valueOf(errorCode), message.getToken());
    }


}
