package cn.benguo.hw.push;

import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.support.v7.app.AppCompatActivity;
import android.util.Log;
import android.widget.TextView;

import cn.benguo.core.push.RouteOperator;

public class HuaWeiPushActivity extends AppCompatActivity {

    private static final String TAG = "HuaWeiPushActivity";
    private TextView tvLog;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
//        setContentView(R.layout.activity_huawei_push);
        Uri uri = getIntent().getData();
        if (uri != null) {
            Log.i(TAG, "onCreate: "+uri.toString());
            String title = uri.getQueryParameter("title");
            String content = uri.getQueryParameter("content");
            String json = uri.getQueryParameter("json");
            RouteOperator.receiveNotificationClick(this, "1000",title, content, json, null);
        }
        finish();
    }

    @Override
    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);

    }

    public void displayLog(Intent intent) {
        //开始获取数据
        if (intent.getData() != null) {
            Uri data = intent.getData();
            tvLog.append(data.toString());
        }

        if (intent.getExtras() != null) {
            tvLog.append("\n\n");
            tvLog.append(intent.getExtras().toString());
        }

    }
}
