package cn.benguo.hw.push.cache;

import android.content.Context;
import android.content.SharedPreferences;

/**
 * use for cache huawei push cache
 * Created by pyt on 2017/3/24.
 */

public class TokenCache {

     static final String SHARE_FILE_NAME = "huawei_push";
     static final String HUAWEI_PUSH_TOKEN = "huawei_push_token";

    /**
     * save huawei push token ,when register huawei push
     * @param context
     * @param token
     */
    public static void savePushToken(Context context,String token){
        SharedPreferences sharedPreferences = context.getSharedPreferences(SHARE_FILE_NAME, Context.MODE_PRIVATE);
        sharedPreferences.edit().putString(HUAWEI_PUSH_TOKEN, token).commit();
    }

    /**
     * get huawei push ,when you unregister huawei push
     * @param context
     * @return
     */
    public static String getPushToken(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(SHARE_FILE_NAME, Context.MODE_PRIVATE);
        return sharedPreferences.getString(HUAWEI_PUSH_TOKEN,null);
    }


    public static void clear(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(SHARE_FILE_NAME, Context.MODE_PRIVATE);
        sharedPreferences.edit().clear().commit();
    }
}
