package cn.benguo.hw.push.route.action;

import android.content.Context;
import android.text.TextUtils;

import com.huawei.android.pushagent.api.PushManager;
import com.spinytech.macore.MaActionResult;

import java.util.HashMap;

import cn.benguo.hw.push.cache.TokenCache;

/**
 * Created by pyt on 2017/3/24.
 */

public class OnUnregisterAction extends BaseAction {

    @Override
    public MaActionResult invoke(Context context, HashMap<String, String> requestData) {
        log(requestData.toString());
        String pushToken = TokenCache.getPushToken(context.getApplicationContext());

        log(pushToken+requestData.toString());
        if (TextUtils.isEmpty(pushToken)) {
            return getCommonErrorResult("the push token is null,can't unregister");
        }
        TokenCache.clear(context);
        PushManager.deregisterToken(context,pushToken);
        PushManager.enableReceiveNotifyMsg(context.getApplicationContext(),false);
        PushManager.enableReceiveNormalMsg(context.getApplicationContext(), false);
        return getCommonSuccessResult();
    }
}
