package cn.benguo.hw.push;

import android.content.Context;
import android.os.Bundle;
import android.util.Log;

import com.huawei.android.pushagent.api.PushEventReceiver;

import java.nio.charset.Charset;

import cn.benguo.core.push.RouteOperator;
import cn.benguo.hw.push.cache.TokenCache;
import cn.benguo.hw.push.utils.JsonArrayToObjectUtils;

import static com.huawei.android.pushselfshow.richpush.html.HtmlViewer.TAG;

/*
 * 接收Push所有消息的广播接收器
 */
public class HuaWeiPushReceiver extends PushEventReceiver {



    /**
     * PushManager.requestToken(Cotnext)后，会回调这个方法
     *
     * @param context
     * @param token
     * @param extras
     */
    @Override
    public void onToken(Context context, String token, Bundle extras) {
        TokenCache.savePushToken(context,token);
        String belongId = extras.getString("belongId");
        RouteOperator.receiveRegisterResult(context,"0",token);

    }


    /**
     * 当收到透传消息时候，会进行回调
     *
     * @param context
     * @param msg
     * @param bundle
     * @return
     */
    @Override
    public boolean onPushMsg(Context context, byte[] msg, Bundle bundle) {
        RouteOperator.receiveMessage(context,null,new String(msg,Charset.forName("UTF-8")),null,null);
        return false;
    }


    /**
     * 和上面的方法一样，会被同时调用
     *
     * @param context
     * @param bytes
     * @param deviceToken
     */
    @Override
    public void onPushMsg(Context context, byte[] bytes, String deviceToken) {
        super.onPushMsg(context, bytes, deviceToken);
    }

    /**
     * 调用 PushManager.requestPushState(context);
     * 会回调该方法
     *
     * @param context
     * @param b
     */
    @Override
    public void onPushState(Context context, boolean b) {
        super.onPushState(context, b);
    }

    /**
     * NOTIFICATION_OPENED,     //通知栏中的通知被点击打开
     * NOTIFICATION_CLICK_BTN, //通知栏中通知上的按钮被点击
     * <p>
     * event                       extras参数                   描述
     * NOTIFICATION_OPENED          BOUND_KEY.pushMsgKey        附加信息，由业务自行处理，需要在华为开发者联盟上，推送消息时添加自定义的键值对，才会回调
     * NOTIFICATION_CLICK_BIN       BOUND_KEY.pushMsgKey        匹配该字符串以决定点击按钮后处理何种事件
     * BOUND_KEY.pushNotifyId      通知栏id，点击通知栏上的按钮后，业务可根据需要清除掉该通知栏或保留，默认保留
     *
     * @param context
     * @param event
     * @param extras
     */
    @Override
    public void onEvent(final Context context, Event event, final Bundle extras) {
        Log.d(TAG, "onEvent() called with: context = [" + context + "], event = [" + event + "], extras = [" + extras + "]");

        //TODO:NOTIFICATION_OPENED注意，key和value必须有值，否则这个方法将不会调用
        //TODO:NOTIFICATION_CLICK_BTN,这个暂时不知道有什么卵用

        if (Event.NOTIFICATION_OPENED.equals(event)) {
            String keyValue = extras.getString(BOUND_KEY.pushMsgKey);
            if (keyValue.length() > 2) {
//                StringBuilder builder = new StringBuilder(keyValue);
//                builder.deleteCharAt(builder.length() - 1);
//                builder.deleteCharAt(0);
                RouteOperator.receiveNotificationClick(context, String.valueOf(extras.getInt(BOUND_KEY.pushNotifyId)),
                        null, null, JsonArrayToObjectUtils.getJsonObjByJsonArrayString(keyValue), null);
            } else {
                RouteOperator.receiveNotificationClick(context, String.valueOf(extras.getInt(BOUND_KEY.pushNotifyId)),
                        null, null,null, null);
            }


        }else if (Event.PLUGINRSP.equals(event)) {
            final int TYPE_LBS = 1;
            final int TYPE_TAG = 2;
            int reportType = extras.getInt(BOUND_KEY.PLUGINREPORTTYPE, -1);
            boolean isSuccess = extras.getBoolean(BOUND_KEY.PLUGINREPORTRESULT, false);
            if (TYPE_TAG == reportType) {
                RouteOperator.receiveCommandResult(context,"20001",isSuccess?"0":"-1",null,extras.toString());
            }
        }
    }


}
