package cn.benguo.hw.push;

import android.content.Context;
import android.content.Intent;

import com.huawei.android.pushagent.PushEventReceiver;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.nio.charset.Charset;

import cn.benguo.core.push.RouteOperator;
import cn.benguo.hw.push.utils.JsonArrayToObjectUtils;

/**
 * Created by pyt on 2017/3/24.
 */

public class HuaWeiFixBugReceiver extends PushEventReceiver {

    private static final String TAG = "HuaWeiFixBugReceiver";

    /**
     *{
     "msgType": 1,
     "msgContent": {
     "psContent": {
     "param": {
     "appPackageName": "benguo.zhba.android"
     },
     "notifyIcon": "",
     "cmd": "cosa",
     "content": "tete",
     "notifyTitle": "tet"
     },
     "dispPkgName": "benguo.zhba.android",
     "fm": 2,
     "msgId": "1511127522",
     "notifyIcon": "",
     "extras": [
     {
     "tet": "tete"
     }
     ],
     "rtn": 5,
     "ap": "1111111100011111111111111111100"
     }
     }
     */

    /**
     * @param context
     * @param intent
     */

    @Override
    public void onReceive(Context context, Intent intent) {
        if ("com.huawei.intent.action.PUSH".equals(intent.getAction())&&48==intent.getFlags()) {

            byte[] selfshow_infos = intent.getByteArrayExtra("selfshow_info");
            String json = new String(selfshow_infos, Charset.forName("UTF-8"));
            try {
                JSONObject response = new JSONObject(json);
                if (1!=response.getInt("msgType")) {
                    return;
                }
                JSONObject msgContent = response.getJSONObject("msgContent");
                JSONObject psContent = msgContent.getJSONObject("psContent");
                String title = psContent.getString("notifyTitle");
                String content = psContent.getString("content");
                JSONArray extras = msgContent.getJSONArray("extras");
                RouteOperator.receiveNotification(context, "0", title, content, JsonArrayToObjectUtils.getJsonObjByJsonArrayString(extras.toString()), null);
            } catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

}
