package cn.benguo.push.proxy;

import android.content.Context;

import com.spinytech.macore.MaApplication;
import com.spinytech.macore.router.LocalRouter;
import com.spinytech.macore.router.RouterRequest;

import cn.benguo.push.IBenguoPush;
import cn.benguo.push.Platform;
import cn.benguo.push.utils.RomUtils;

/**
 * Created by pyt on 2017/3/27.
 */

public class DefaultPushProxy implements IBenguoPush {

    public final String PLATFORM_HUA_WEI = "huawei_push";

    public final String PLATFORM_XIAO_MI = "mi_push";

    public final String PLATFORM_XIN_GE = "xinge_push";

    //当前默认的推送平台
    private String curPlatform;
    private Platform mCurrentPushPlatform;

    public DefaultPushProxy(){
        if (RomUtils.isMiuiRom()) {
            curPlatform = PLATFORM_XIAO_MI;
            mCurrentPushPlatform = Platform.XIAO_MI;
        } else if (RomUtils.isHuaweiRom()) {
            curPlatform = PLATFORM_HUA_WEI;
            mCurrentPushPlatform = Platform.HUA_WEI;
        }else{
            curPlatform = PLATFORM_XIAO_MI;
            mCurrentPushPlatform = Platform.XIAO_MI;
        }
    }



    @Override
    public void register(Context context) {
        try {
            LocalRouter.getInstance(MaApplication.getMaApplication())
                    .route(getAppContext(context),RouterRequest.obtain(getAppContext(context))
                    .provider(curPlatform)
                    .action("register"));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void unregister(Context context) {
        try {
            LocalRouter.getInstance(MaApplication.getMaApplication())
                    .route(getAppContext(context),RouterRequest.obtain(getAppContext(context))
                            .provider(curPlatform)
                            .action("unregister"));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setTag(Context context, String key, String value) {
        try {
            LocalRouter.getInstance(MaApplication.getMaApplication())
                    .route(getAppContext(context),RouterRequest.obtain(getAppContext(context))
                            .provider(curPlatform)
                            .action("set_tag")
                            .data(key,value));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void delTag(Context context, String key, String value) {
        try {
            LocalRouter.getInstance(MaApplication.getMaApplication())
                    .route(getAppContext(context),RouterRequest.obtain(getAppContext(context))
                            .provider(curPlatform)
                            .action("delete_tag")
                            .data(key,value));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void getTag(Context context) {
        try {
            LocalRouter.getInstance(MaApplication.getMaApplication())
                    .route(getAppContext(context), RouterRequest.obtain(getAppContext(context))
                            .provider(curPlatform)
                            .action("get_tag"));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void bindAccount(Context context, String account) {
        try {
            LocalRouter.getInstance(MaApplication.getMaApplication())
                    .route(getAppContext(context), RouterRequest.obtain(getAppContext(context))
                            .provider(curPlatform)
                            .action("bind_account")
                            .data("account", account));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void unbindAccount(Context context, String account) {
        try {
            LocalRouter.getInstance(MaApplication.getMaApplication())
                    .route(getAppContext(context), RouterRequest.obtain(getAppContext(context))
                            .provider(curPlatform)
                            .action("unbind_account")
                            .data("account", account));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public Platform getCurrentPushPlatform() {
        return mCurrentPushPlatform;
    }


    private Context getAppContext(Context context){
        return context.getApplicationContext();
    }
}
