package cn.benguo.push;

import android.content.Context;

import com.spinytech.macore.MaApplication;
import com.spinytech.macore.multiprocess.BaseApplicationLogic;

import cn.benguo.push.route.BenguoPushApplicationLogic;

/**
 * Created by pyt on 2017/3/24.
 */

public abstract class BenguoPushApplication extends MaApplication {

    public abstract String getMainProcessName();

    @Override
    public void onCreate() {
        super.onCreate();
        BenguoPush.init(this);

    }

    @Override
    protected void attachBaseContext(Context base) {
        super.attachBaseContext(base);
    }

    @Override
    public void initializeAllProcessRouter() {
    }

    @Override
    protected void initializeLogic() {

        /**
         *  registerApplicationLogic(getMainProcessName(), 999, BenguoPushApplicationLogic.class);
         *registerApplicationLogic(getMainProcessName(), 999, MiPushLogic.class);
         *registerApplicationLogic(getMainProcessName(), 999, HuaWeiPushLogic.class);
         *registerApplicationLogic(getMainProcessName(), 999, XinGePushLogic.class);
         */

        registerApplicationLogic(getMainProcessName(), 999, BenguoPushApplicationLogic.class);

        try {
            registerApplicationLogic(getMainProcessName(), 999, (Class<? extends BaseApplicationLogic>) Class.forName("cn.benguo.hw.push.route.HuaWeiPushLogic"));
        } catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        try {
            registerApplicationLogic(getMainProcessName(), 999, (Class<? extends BaseApplicationLogic>) Class.forName("cn.benguo.xg.push.route.XinGePushLogic"));
        } catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        try {
            registerApplicationLogic(getMainProcessName(), 999, (Class<? extends BaseApplicationLogic>) Class.forName("cn.benguo.xm.push.route.MiPushLogic"));
        } catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean needMultipleProcess() {
        return false;
    }
}
