package cn.benguo.push.route.action;

import android.content.Context;
import android.content.Intent;

import com.spinytech.macore.MaActionResult;

import java.util.HashMap;

import cn.benguo.push.receiver.IntentExtra;
import cn.benguo.push.receiver.ReceiverAction;

/**
 * Created by pyt on 2017/3/24.
 */

public class OnCommandAction extends BenguoPushAction {

    @Override
    public boolean isAsync(Context context, HashMap<String, String> requestData) {
        return false;
    }

    @Override
    public MaActionResult invoke(Context context, HashMap<String, String> requestData) {
        log(requestData.toString());

        //取出相关的值
        String type = requestData.get("type");
        String resultCode = requestData.get("result_code");
        String extraMessage = requestData.get("extra_message");
        String error = requestData.get("error");
        Intent intent = new Intent(ReceiverAction.ACTION_RECEIVE_COMMAND_RESULT);
        MaActionResult response = null;
        try {

            intent.putExtra(IntentExtra.COMMAND_TYPE, Integer.parseInt(type));
            intent.putExtra(IntentExtra.COMMAND_RESULT_CODE, Integer.parseInt(resultCode));
            intent.putExtra(IntentExtra.COMMAND_EXTRA_MESSAGE, extraMessage);
            intent.putExtra(IntentExtra.COMMAND_ERROR, error);
            sendBroadcast(context,intent);
            response = new MaActionResult.Builder()
                    .code(MaActionResult.CODE_SUCCESS)
                    .msg("success")
                    .build();
        } catch (NumberFormatException e) {
            e.printStackTrace();
            response = new MaActionResult.Builder()
                    .code(MaActionResult.CODE_ERROR)
                    .msg(e.getMessage())
                    .build();
        }
        return response;
    }
}
