package cn.benguo.push.route.action;

import android.content.Context;
import android.content.Intent;

import com.spinytech.macore.MaActionResult;

import java.util.HashMap;

import cn.benguo.push.receiver.IntentExtra;
import cn.benguo.push.receiver.ReceiverAction;

/**
 * Created by pyt on 2017/3/24.
 */

public class OnNotificationAction extends BenguoPushAction {


    @Override
    public boolean isAsync(Context context, HashMap<String, String> requestData) {
        return false;
    }

    @Override
    public MaActionResult invoke(Context context, HashMap<String, String> requestData) {

        log(requestData.toString());
        MaActionResult result = null;

        String notifyId = requestData.get("notify_id");
        String title = requestData.get("title");
        String content = requestData.get("content");
        String extraMessage = requestData.get("extra_message");
        String keyValue = requestData.get("key_value");
        Intent intent = new Intent(ReceiverAction.ACTION_RECEIVE_NOTIFICATION);
        try {
            int i = Integer.parseInt(notifyId);
            intent.putExtra(IntentExtra.NOTIFICATION_ID, i);
        } catch (NumberFormatException e) {
            e.printStackTrace();
        }

        intent.putExtra(IntentExtra.NOTIFICATION_TITLE, title);
        intent.putExtra(IntentExtra.NOTIFICATION_CONTENT, content);
        intent.putExtra(IntentExtra.NOTIFICATION_EXTRA_MESSAGE, extraMessage);
        intent.putExtra(IntentExtra.NOTIFICATION_KEY_VALUE, keyValue);
        sendBroadcast(context, intent);
        result = new MaActionResult.Builder()
                .code(MaActionResult.CODE_SUCCESS)
                .msg("success")
                .build();


        return result;
    }
}
