package cn.benguo.push.route.action;

import android.content.Context;
import android.content.Intent;

import com.spinytech.macore.MaActionResult;

import java.util.HashMap;

import cn.benguo.push.receiver.IntentExtra;
import cn.benguo.push.receiver.ReceiverAction;

/**
 * Created by pyt on 2017/3/24.
 */

public class OnMessageAction extends BenguoPushAction {
    @Override
    public boolean isAsync(Context context, HashMap<String, String> requestData) {
        return false;
    }

    @Override
    public MaActionResult invoke(Context context, HashMap<String, String> requestData) {
        log(requestData.toString());
        String title = requestData.get("title");
        String content = requestData.get("content");
        String keyValue = requestData.get("key_value");
        String extraMessage = requestData.get("extra_message");

        Intent intent = new Intent(ReceiverAction.ACTION_RECEIVE_MESSAGE);
        intent.putExtra(IntentExtra.MESSAGE_TITLE, title);
        intent.putExtra(IntentExtra.MESSAGE_CONTENT, content);
        intent.putExtra(IntentExtra.MESSAGE_KEY_VALUE, keyValue);
        intent.putExtra(IntentExtra.MESSAGE_EXTRA_MESSAGE, extraMessage);
        sendBroadcast(context, intent);

        MaActionResult result = new MaActionResult.Builder()
                .code(MaActionResult.CODE_SUCCESS)
                .msg("success")
                .build();

        return result;
    }
}
