package cn.benguo.push.receiver;

import android.content.Context;

import cn.benguo.push.entity.BenguoPushCommandMsg;
import cn.benguo.push.entity.BenguoPushMsg;

/**
 * Created by pyt on 2017/3/23.
 */

public interface IPushReceiver {

    /**
     * 当收到通知
     *
     * @param context
     * @param notification
     */
    void onReceiveNotification(Context context, BenguoPushMsg notification);

    /**
     * 当收到的通知被点击
     *
     * @param context
     * @param notification
     */
    void onReceiveNotificationClick(Context context, BenguoPushMsg notification);

    /**
     * 当收到透传消息
     *
     * @param context
     * @param message
     */
    void onReceiveMessage(Context context, BenguoPushMsg message);

    /**
     * 注册推送时候进行回调
     *
     * @param context
     * @param commandMsg
     */
    void onRegisterResult(Context context, BenguoPushCommandMsg commandMsg);

    /**
     * 客户端调用执行命令的时候，进行回调
     * 例如：setTag
     *
     * @param context
     * @param commandMsg
     */
    void onCommandResult(Context context, BenguoPushCommandMsg commandMsg);

}
