package cn.benguo.push;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.util.Log;
import android.widget.Toast;

import java.util.List;

import cn.benguo.push.entity.BenguoPushCommandMsg;
import cn.benguo.push.entity.BenguoPushMsg;
import cn.benguo.push.receiver.BenguoBaseReceiver;
import cn.benguo.push.receiver.PushCommandCode;

/**
 * default push receiver
 * <p>
 * <p>
 * <p>
 * Created by pyt on 2017/3/24.
 */

public class BenguoPushTestReceiver extends BenguoBaseReceiver {

    //TODO:注意这个里面的需要涉及到线程的切换

    private static final String TAG = "BenguoPushTestReceiver";


    @Override
    public void onReceiveNotification(Context context, BenguoPushMsg notification) {
        Log.d(TAG, "onReceiveNotification() called with: context = [" + context + "], notification = [" + notification + "]");
        StringBuilder builder = new StringBuilder();
        builder.append("\n").append("---通知----").append("\n");
        builder.append(notification.toString());
        sendTestReceiver(context, builder.toString());

    }

    @Override
    public void onReceiveNotificationClick(Context context, BenguoPushMsg notification) {

        Log.d(TAG, "onReceiveNotificationClick() called with: context = [" + context + "], notification = [" + notification + "]");
        StringBuilder builder = new StringBuilder();
        builder.append("\n").append("---通知被点击----").append("\n");
        builder.append(notification.toString());
        openCLD("benguo.zhba.android", context, builder.toString());
    }

    @Override
    public void onReceiveMessage(Context context, BenguoPushMsg message) {
        Log.d(TAG, "onReceiveMessage() called with: context = [" + context + "], message = [" + message + "]");
        StringBuilder builder = new StringBuilder();
        builder.append("\n").append("---透传消息----").append("\n");
        builder.append(message.toString());
        sendTestReceiver(context, builder.toString());

    }

    @Override
    public void onRegisterResult(Context context, BenguoPushCommandMsg commandMsg) {
        Log.d(TAG, "onRegisterResult() called with: context = [" + context + "], commandMsg = [" + commandMsg + "]");

        StringBuilder builder = new StringBuilder();
        builder.append("\n").append("---注册结果----").append("\n");
        if (commandMsg.getResultCode() == PushCommandCode.SUCCESS) {
            builder.append("token: ").append(commandMsg.getToken());
        } else {
            builder.append("注册失败，请检查log信息");

        }
        sendTestReceiver(context, builder.toString());
    }

    @Override
    public void onCommandResult(Context context, BenguoPushCommandMsg commandMsg) {
        Log.d(TAG, "onCommandResult() called with: context = [" + context + "], commandMsg = [" + commandMsg + "]");
        int command = commandMsg.getCommand();

        String commandType = null;

        switch (command) {
            case PushCommandCode.COMMAND_SET_TAG:
                commandType = "设置标签";
                break;
            case PushCommandCode.COMMAND_DEL_TAG:
                commandType = "删除标签";
                break;
            case PushCommandCode.COMMAND_UNREGISTER:
                commandType = "取消注册";
                break;
            case PushCommandCode.COMMAND_BIND_ACCOUNT:
                commandType = "绑定账号";
                break;
            case PushCommandCode.COMMAND_UNBIND_ACCOUNT:
                commandType = "取消绑定账号";
                break;
            default:
                break;

        }

        StringBuilder builder = new StringBuilder();
        builder.append("\n----").append(commandType).append("----\n");
        if (commandMsg.getResultCode() == PushCommandCode.SUCCESS) {
            builder.append("操作成功");
        } else {
            builder.append("操作失败").append(commandMsg.getResultCode());
        }
        builder.append("\n").append(commandMsg.toString());
        sendTestReceiver(context, builder.toString());
    }

    private void sendTestReceiver(Context context, String log) {
        Intent intent = new Intent("cn.benguo.push.TEST_UI");
        intent.putExtra("log", log);
        Toast.makeText(context, log, Toast.LENGTH_SHORT).show();
        context.sendBroadcast(intent);
    }


    public static void openCLD(String packageName, Context context, String msg) {
        PackageManager packageManager = context.getPackageManager();
        PackageInfo pi = null;

        try {
            pi = packageManager.getPackageInfo(packageName, 0);
        } catch (PackageManager.NameNotFoundException e) {

        }
        Intent resolveIntent = new Intent(Intent.ACTION_MAIN, null);
        resolveIntent.addCategory(Intent.CATEGORY_LAUNCHER);
        resolveIntent.setPackage(pi.packageName);

        List<ResolveInfo> apps = packageManager.queryIntentActivities(resolveIntent, 0);

        ResolveInfo ri = apps.iterator().next();
        if (ri != null) {
            String className = ri.activityInfo.name;

            Intent intent = new Intent(Intent.ACTION_MAIN);
            intent.addCategory(Intent.CATEGORY_LAUNCHER);
            intent.putExtra("msg", msg);
            if (!(context instanceof Activity)) {
                intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK|Intent.FLAG_ACTIVITY_SINGLE_TOP);
            }
            ComponentName cn = new ComponentName(packageName, className);

            intent.setComponent(cn);
            context.startActivity(intent);
        }
    }

}
