package cn.benguo.push;

import android.content.Context;

import cn.benguo.push.proxy.DefaultPushProxy;
import cn.benguo.push.utils.RomUtils;

/**
 * Created by pyt on 2017/3/24.
 */

public class BenguoPush {

    private static IBenguoPush push;

    public static void init(Context context){
        push = new DefaultPushProxy();
    }


    public static void register(Context context) {
        push.register(context);
    }

    public static  void unregister(Context context) {
        push.unregister(context);
    }

    public static void setTag(Context context, String key,String value) {
        push.setTag(context,key,value);
    }

    public static void delTag(Context context,  String key,String value) {
        push.delTag(context,key,value);
    }

    public static void getTag(Context context) {
        push.getTag(context);
    }

    public static void bindAccount(Context context, String account) {
        push.bindAccount(context,account);
    }

    public static void unbindAccount(Context context, String account) {
        push.unbindAccount(context,account);
    }


    public static Platform getPushPlatform(){
        return RomUtils.isMiuiRom() ? Platform.XIAO_MI : RomUtils.isHuaweiRom() ? Platform.HUA_WEI : Platform.XIN_GE;
    }
}
