package cn.benguo.push.receiver;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.util.Log;

import cn.benguo.push.entity.BenguoPushCommandMsg;
import cn.benguo.push.entity.BenguoPushMsg;

/**
 * benguo notification and message base receiver
 *
 * Created by pyt on 2017/3/23.
 */

public abstract class BenguoBaseReceiver extends BroadcastReceiver implements IPushReceiver {

    private static final String TAG = "BenguoBaseReceiver";

    @Override
    public final void onReceive(Context context, Intent intent) {
        //对收到的消息进行分类
        if (ReceiverAction.ACTION_RECEIVE_COMMAND_RESULT.equals(intent.getAction())) {
            int type = intent.getIntExtra(IntentExtra.COMMAND_TYPE, -1);
            int resultCode = intent.getIntExtra(IntentExtra.COMMAND_RESULT_CODE, -1);
            String stringExtra = intent.getStringExtra(IntentExtra.COMMAND_EXTRA_MESSAGE);
            String error = intent.getStringExtra(IntentExtra.COMMAND_ERROR);
            BenguoPushCommandMsg benguoPushCommandMsg = new BenguoPushCommandMsg();
            benguoPushCommandMsg.setCommand(type);
            benguoPushCommandMsg.setError(error);
            benguoPushCommandMsg.setResultCode(resultCode);
            benguoPushCommandMsg.setExtraMsg(stringExtra);
            onCommandResult(context,benguoPushCommandMsg);
        } else if (ReceiverAction.ACTION_RECEIVE_MESSAGE.equals(intent.getAction())) {
            String msgTitle = intent.getStringExtra(IntentExtra.MESSAGE_TITLE);
            String msgContent = intent.getStringExtra(IntentExtra.MESSAGE_CONTENT);
            String msgKeyValue = intent.getStringExtra(IntentExtra.MESSAGE_KEY_VALUE);
            String msgExtra = intent.getStringExtra(IntentExtra.MESSAGE_EXTRA_MESSAGE);
            BenguoPushMsg benguoPushMsg = new BenguoPushMsg();
            benguoPushMsg.setTitle(msgTitle);
            benguoPushMsg.setContent(msgContent);
            benguoPushMsg.setExtraMsg(msgExtra);
            benguoPushMsg.setKeyValue(msgKeyValue);
            onReceiveMessage(context, benguoPushMsg);
        } else if (ReceiverAction.ACTION_RECEIVE_NOTIFICATION.equals(intent.getAction())) {
            int notifyId = intent.getIntExtra(IntentExtra.NOTIFICATION_ID,-1);
            String notifyTitle = intent.getStringExtra(IntentExtra.NOTIFICATION_TITLE);
            String notifyContent = intent.getStringExtra(IntentExtra.NOTIFICATION_CONTENT);
            String notifyKeyValue = intent.getStringExtra(IntentExtra.NOTIFICATION_KEY_VALUE);
            String notifyExtra = intent.getStringExtra(IntentExtra.NOTIFICATION_EXTRA_MESSAGE);
            BenguoPushMsg benguoPushMsg = new BenguoPushMsg();
            benguoPushMsg.setNotifyId(notifyId);
            benguoPushMsg.setTitle(notifyTitle);
            benguoPushMsg.setContent(notifyContent);
            benguoPushMsg.setExtraMsg(notifyExtra);
            benguoPushMsg.setKeyValue(notifyKeyValue);
            onReceiveNotification(context,benguoPushMsg);
        } else if (ReceiverAction.ACTION_RECEIVE_NOTIFICATION_CLICK.equals(intent.getAction())) {
            int notifyId = intent.getIntExtra(IntentExtra.NOTIFICATION_ID,-1);
            String notifyTitle = intent.getStringExtra(IntentExtra.NOTIFICATION_TITLE);
            String notifyContent = intent.getStringExtra(IntentExtra.NOTIFICATION_CONTENT);
            String notifyKeyValue = intent.getStringExtra(IntentExtra.NOTIFICATION_KEY_VALUE);
            String notifyExtra = intent.getStringExtra(IntentExtra.NOTIFICATION_EXTRA_MESSAGE);
            BenguoPushMsg benguoPushMsg = new BenguoPushMsg();
            benguoPushMsg.setNotifyId(notifyId);
            benguoPushMsg.setTitle(notifyTitle);
            benguoPushMsg.setContent(notifyContent);
            benguoPushMsg.setExtraMsg(notifyExtra);
            benguoPushMsg.setKeyValue(notifyKeyValue);
            onReceiveNotificationClick(context,benguoPushMsg);
        } else if (ReceiverAction.ACTION_RECEIVE_REGISTER_RESULT.equals(intent.getAction())) {
            int code = intent.getIntExtra(IntentExtra.REGISTER_CODE, -1);
            String token = intent.getStringExtra(IntentExtra.REGISTER_TOKEN);
            BenguoPushCommandMsg benguoPushCommandMsg = new BenguoPushCommandMsg();
            benguoPushCommandMsg.setResultCode(code);
            benguoPushCommandMsg.setToken(token);
            onRegisterResult(context,benguoPushCommandMsg);
        } else {
            Log.e(TAG, "onReceive: 非法Action："+intent.getAction() );
        }

        Log.i(TAG, "收到Action:  " + intent.getAction() + "  data:  " + intent.getExtras().toString());

    }




}
