package cn.benguo.push.route.action;

import android.content.Context;
import android.content.Intent;

import com.spinytech.macore.MaActionResult;

import java.util.HashMap;

import cn.benguo.push.receiver.IntentExtra;
import cn.benguo.push.receiver.ReceiverAction;

/**
 * Created by pyt on 2017/3/24.
 */

public class OnRegisterAction extends BenguoPushAction {

    private static final String TAG = "OnRegisterAction_Benguo";

    @Override
    public boolean isAsync(Context context, HashMap<String, String> requestData) {
        return false;
    }

    /**
     *    try {
     LocalRouter.getInstance(MaApplication.getMaApplication())
     .route(context, RouterRequest
     .obtain(context)
     .provider("benguo_push")
     .action("receive_register_result")
     .data("code", "0")
     .data("", "")
     );
     } cache (Exception e) {
     e.printStackTrace();
     }


     *
     *
     *
     * @param context
     * @param requestData
     * @return
     */
    @Override
    public MaActionResult invoke(Context context, HashMap<String, String> requestData) {

        log(requestData.toString());

        MaActionResult result;
        try {
            String code = requestData.get("code");
            String token = requestData.get("token");
            Intent intent = new Intent(ReceiverAction.ACTION_RECEIVE_REGISTER_RESULT);
            intent.putExtra(IntentExtra.REGISTER_CODE, Integer.parseInt(code));
            intent.putExtra(IntentExtra.REGISTER_TOKEN, token);
            sendBroadcast(context, intent);
            result = new MaActionResult.Builder()
                    .code(MaActionResult.CODE_SUCCESS)
                    .msg("success")
                    .build();
        } catch (NumberFormatException e) {
            e.printStackTrace();
            result = new MaActionResult.Builder()
                    .code(MaActionResult.CODE_ERROR)
                    .msg(e.getMessage())
                    .build();
        }
        return result;
    }
}
