/*
 * Decompiled with CFR 0.152.
 */
package cn.beecloud;

import cn.beecloud.BCCache;
import cn.beecloud.BCEumeration;
import cn.beecloud.BCUtil;
import cn.beecloud.BCUtilPrivate;
import cn.beecloud.MD5;
import cn.beecloud.RequestUtil;
import cn.beecloud.StrUtil;
import cn.beecloud.ValidationUtil;
import cn.beecloud.bean.ALITransferData;
import cn.beecloud.bean.BCAuth;
import cn.beecloud.bean.BCBatchRefund;
import cn.beecloud.bean.BCBillConfirm;
import cn.beecloud.bean.BCException;
import cn.beecloud.bean.BCGateWayBanks;
import cn.beecloud.bean.BCHistoryBills;
import cn.beecloud.bean.BCInternationlOrder;
import cn.beecloud.bean.BCOrder;
import cn.beecloud.bean.BCQueryParameter;
import cn.beecloud.bean.BCRefund;
import cn.beecloud.bean.BCT0TransferParameter;
import cn.beecloud.bean.BCTransferBanks;
import cn.beecloud.bean.BCTransferParameter;
import cn.beecloud.bean.TransferParameter;
import cn.beecloud.bean.TransfersParameter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;

public class BCPay {
    private static final String TEST_MODE_SUPPORT_ERROR = "\u6d4b\u8bd5\u6a21\u5f0f\u4ec5\u652f\u6301\u56fd\u5185\u652f\u4ed8(WX_JSAPI\u6682\u4e0d\u652f\u6301)\u3001\u8ba2\u5355\u67e5\u8be2\u3001\u8ba2\u5355\u603b\u6570\u67e5\u8be2\u3001\u5355\u7b14\u8ba2\u5355\u67e5\u8be2";

    public static BCOrder startBCPay(BCOrder order) throws BCException {
        ValidationUtil.validateBCPay(order);
        HashMap<String, Object> param = new HashMap<String, Object>();
        BCPay.buildPayParam(param, order);
        if (BCCache.isSandbox()) {
            if (order.getChannel().equals((Object)BCEumeration.PAY_CHANNEL.WX_JSAPI)) {
                throw new BCException(-2, BCEumeration.RESULT_TYPE.OTHER_ERROR.name(), TEST_MODE_SUPPORT_ERROR);
            }
            Map<String, Object> ret = RequestUtil.doPost(BCUtilPrivate.getkSandboxApiPay(), param);
            BCPay.placeSandboxOrder(order, ret);
            if (order.getChannel().equals((Object)BCEumeration.PAY_CHANNEL.YEE_NOBANKCARD)) {
                RequestUtil.doGet(BCUtilPrivate.getkApiSandboxNotify() + "/" + BCCache.getAppID() + "/" + order.getObjectId() + "?para=", new HashMap<String, Object>());
            }
            return order;
        }
        Map<String, Object> ret = RequestUtil.doPost(BCUtilPrivate.getkApiPay(), param);
        BCPay.placeOrder(order, ret);
        return order;
    }

    public static Map<String, Object> billConfirm(BCBillConfirm confirm) throws BCException {
        ValidationUtil.validateBCBillConfirm(confirm);
        HashMap<String, Object> param = new HashMap<String, Object>();
        BCPay.buildBillConfirmParam(param, confirm);
        Map<String, Object> ret = RequestUtil.doPost(BCUtilPrivate.getkApiBillConfirm(), param);
        return ret;
    }

    public static BCOrder startBCOfflinePay(BCOrder order) throws BCException {
        ValidationUtil.validateBCPay(order);
        HashMap<String, Object> param = new HashMap<String, Object>();
        BCPay.buildPayParam(param, order);
        Map<String, Object> ret = RequestUtil.doPost(BCUtilPrivate.getkApiOfflinePay(), param);
        BCPay.placeOfflineOrder(order, ret);
        return order;
    }

    public static BCAuth startBCAuth(BCAuth auth) throws BCException {
        HashMap<String, Object> param = new HashMap<String, Object>();
        BCPay.buildAuthParam(param, auth);
        Map<String, Object> ret = RequestUtil.doPost(BCUtilPrivate.getkApiAuth(), param);
        BCPay.placeAuth(auth, ret);
        return auth;
    }

    public static Map<String, Object> startBCTransfer(BCTransferParameter bcTransferParameter) throws BCException {
        ValidationUtil.validateBCTransfer(bcTransferParameter);
        HashMap<String, Object> param = new HashMap<String, Object>();
        BCPay.buildBCTransferParam(param, bcTransferParameter);
        return RequestUtil.doPost(BCUtilPrivate.getkApiBCTransfer(), param);
    }

    public static Map<String, Object> startBCT0transfer(BCT0TransferParameter bcTransferParameter) throws BCException {
        ValidationUtil.validateBCT0Transfer(bcTransferParameter);
        HashMap<String, Object> param = new HashMap<String, Object>();
        BCPay.buildBCT0TransferParam(param, bcTransferParameter);
        return RequestUtil.doPost(BCUtilPrivate.getkApiBCT0Transfer(), param);
    }

    public static BCRefund startBCRefund(BCRefund refund) throws BCException {
        BCPay.checkTestModeSwitch();
        ValidationUtil.validateBCRefund(refund);
        HashMap<String, Object> param = new HashMap<String, Object>();
        BCPay.buildRefundParam(param, refund);
        Map<String, Object> ret = RequestUtil.doPost(BCUtilPrivate.getkApiRefund(), param);
        refund.setObjectId(StrUtil.toStr(ret.get("id")));
        if (ret.containsKey("url")) {
            refund.setAliRefundUrl(StrUtil.toStr(ret.get("url")));
        }
        return refund;
    }

    public static List<BCOrder> startQueryBill(BCQueryParameter para) throws BCException {
        ValidationUtil.validateQueryBill(para);
        HashMap<String, Object> param = new HashMap<String, Object>();
        BCPay.buildQueryParam(param, para);
        if (BCCache.isSandbox()) {
            Map<String, Object> ret = RequestUtil.doGet(BCUtilPrivate.getkApiSandboxQueryBill(), param);
            return BCPay.generateBCOrderList((List)ret.get("bills"));
        }
        Map<String, Object> ret = RequestUtil.doGet(BCUtilPrivate.getkApiQueryBill(), param);
        return BCPay.generateBCOrderList((List)ret.get("bills"));
    }

    public static BCOrder startQueryBillById(String objectId) throws BCException {
        ValidationUtil.validateQueryById(objectId);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("app_id", BCCache.getAppID());
        param.put("timestamp", System.currentTimeMillis());
        StringBuilder urlSb = new StringBuilder();
        if (BCCache.isSandbox()) {
            param.put("app_sign", BCUtilPrivate.getAppSignatureWithTestSecret(StrUtil.toStr(param.get("timestamp"))));
            urlSb.append(BCUtilPrivate.getkApiSandboxQueryBillById());
        } else {
            param.put("app_sign", BCUtilPrivate.getAppSignature(StrUtil.toStr(param.get("timestamp"))));
            urlSb.append(BCUtilPrivate.getkApiQueryBillById());
        }
        urlSb.append("/");
        urlSb.append(objectId);
        urlSb.append("?para=");
        Map<String, Object> ret = RequestUtil.doGet(urlSb.toString(), param);
        return BCPay.generateBCOrder((Map)ret.get("pay"));
    }

    public static Integer startQueryBillCount(BCQueryParameter para) throws BCException {
        ValidationUtil.validateQueryBill(para);
        HashMap<String, Object> param = new HashMap<String, Object>();
        BCPay.buildQueryCountParam(param, para);
        if (BCCache.isSandbox()) {
            Map<String, Object> ret = RequestUtil.doGet(BCUtilPrivate.getkApiSandboxQueryBillCount(), param);
            return (Integer)ret.get("count");
        }
        Map<String, Object> ret = RequestUtil.doGet(BCUtilPrivate.getkApiQueryBillCount(), param);
        return (Integer)ret.get("count");
    }

    public static boolean queryOfflineBillStatus(String bill_no, BCEumeration.PAY_CHANNEL channel) throws BCException {
        HashMap<String, Object> param = new HashMap<String, Object>();
        BCPay.buildQueryOfflineStatusParam(param, bill_no, channel);
        Map<String, Object> ret = RequestUtil.doPost(BCUtilPrivate.getApiOfflineStatusUrl(), param);
        Boolean b = (Boolean)ret.get("pay_result");
        return b == null ? false : b;
    }

    public static List<BCRefund> startQueryRefund(BCQueryParameter para) throws BCException {
        BCPay.checkTestModeSwitch();
        ValidationUtil.validateQueryRefund(para);
        HashMap<String, Object> param = new HashMap<String, Object>();
        BCPay.buildQueryParam(param, para);
        Map<String, Object> ret = RequestUtil.doGet(BCUtilPrivate.getkApiQueryRefund(), param);
        return BCPay.generateBCRefundList((List)ret.get("refunds"));
    }

    public static BCRefund startQueryRefundById(String objectId) throws BCException {
        BCPay.checkTestModeSwitch();
        ValidationUtil.validateQueryById(objectId);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("app_id", BCCache.getAppID());
        param.put("timestamp", System.currentTimeMillis());
        param.put("app_sign", BCUtilPrivate.getAppSignature(StrUtil.toStr(param.get("timestamp"))));
        StringBuilder urlSb = new StringBuilder();
        urlSb.append(BCUtilPrivate.getkApiQueryRefundById());
        urlSb.append("/");
        urlSb.append(objectId);
        urlSb.append("?para=");
        Map<String, Object> ret = RequestUtil.doGet(urlSb.toString(), param);
        return BCPay.generateBCRefund((Map)ret.get("refund"));
    }

    public static Integer startQueryRefundCount(BCQueryParameter para) throws BCException {
        BCPay.checkTestModeSwitch();
        ValidationUtil.validateQueryRefund(para);
        HashMap<String, Object> param = new HashMap<String, Object>();
        BCPay.buildQueryCountParam(param, para);
        Map<String, Object> ret = RequestUtil.doGet(BCUtilPrivate.getkApiQueryRefundCount(), param);
        return (Integer)ret.get("count");
    }

    public static String startRefundUpdate(BCEumeration.PAY_CHANNEL channel, String refundNo) throws BCException {
        BCPay.checkTestModeSwitch();
        ValidationUtil.validateQueryRefundStatus(channel, refundNo);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("app_id", BCCache.getAppID());
        param.put("timestamp", System.currentTimeMillis());
        param.put("app_sign", BCUtilPrivate.getAppSignature(StrUtil.toStr(param.get("timestamp"))));
        param.put("channel", StrUtil.toStr((Object)channel));
        param.put("refund_no", refundNo);
        Map<String, Object> ret = RequestUtil.doGet(BCUtilPrivate.getkApiRefundUpdate(), param);
        return StrUtil.toStr(ret.get("refund_status"));
    }

    public static BCInternationlOrder startBCInternatioalPay(BCInternationlOrder order) throws BCException {
        BCPay.checkTestModeSwitch();
        ValidationUtil.validateBCInternatioalPay(order);
        HashMap<String, Object> param = new HashMap<String, Object>();
        BCPay.buildInternatioalPayParam(param, order);
        Map<String, Object> ret = RequestUtil.doPost(BCUtilPrivate.getApiInternationalPay(), param);
        BCPay.placePayPalOrder(order, ret);
        return order;
    }

    public static String startTransfer(TransferParameter para) throws BCException {
        BCPay.checkTestModeSwitch();
        ValidationUtil.validateBCTransfer(para);
        HashMap<String, Object> param = new HashMap<String, Object>();
        BCPay.buildTransferParam(param, para);
        Map<String, Object> ret = RequestUtil.doPost(BCUtilPrivate.getkApiTransfer(), param);
        if (ret.containsKey("url")) {
            return StrUtil.toStr(ret.get("url"));
        }
        return "";
    }

    public static String startTransfers(TransfersParameter para) throws BCException {
        BCPay.checkTestModeSwitch();
        ValidationUtil.validateBCTransfers(para);
        HashMap<String, Object> param = new HashMap<String, Object>();
        BCPay.buildTransfersParam(param, para);
        Map<String, Object> ret = RequestUtil.doPost(BCUtilPrivate.getkApiTransfers(), param);
        return StrUtil.toStr(ret.get("url"));
    }

    public static BCBatchRefund startBatchRefund(BCBatchRefund batchRefund) throws BCException {
        BCPay.checkTestModeSwitch();
        ValidationUtil.validateBatchRefund(batchRefund);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("channel", StrUtil.toStr((Object)batchRefund.getChannel()));
        param.put("agree", batchRefund.getAgree());
        param.put("ids", batchRefund.getIds());
        param.put("app_id", BCCache.getAppID());
        param.put("timestamp", System.currentTimeMillis());
        param.put("app_sign", BCUtilPrivate.getAppSignature(StrUtil.toStr(param.get("timestamp"))));
        Map<String, Object> ret = RequestUtil.doPut(BCUtilPrivate.getApiBatchRefund(), param);
        if (ret.containsKey("result_map")) {
            batchRefund.setIdResult((Map)ret.get("result_map"));
            if (ret.containsKey("url")) {
                batchRefund.setAliRefundUrl(StrUtil.toStr(ret.get("url")));
            }
        }
        return batchRefund;
    }

    public static Map<String, Object> historyBills(BCHistoryBills historyBills) throws BCException {
        ValidationUtil.validateBCHistoryBills(historyBills);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("bill_info", historyBills.getBillInfo());
        param.put("app_id", BCCache.getAppID());
        param.put("timestamp", Long.valueOf(historyBills.getTimeStamp()));
        param.put("app_sign", BCUtilPrivate.getAppSignature(StrUtil.toStr(param.get("timestamp"))));
        return RequestUtil.doPut(BCUtilPrivate.getApiHistoryBills(), param);
    }

    public static List<String> fetchBCTransfersBanks(BCEumeration.BC_TRANSFER_BANK_TYPE type) throws BCException {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("type", StrUtil.toStr((Object)type));
        param.put("app_id", BCCache.getAppID());
        Map<String, Object> ret = RequestUtil.doGet(BCUtilPrivate.getkApiBCTransferBanks(), param);
        return (List)ret.get("banks");
    }

    public static boolean verifySign(String signature, String transactionId, String transactionType, String channelType, String transactionFee) {
        String masterKey = BCCache.getMasterKey();
        StringBuffer toSign = new StringBuffer();
        toSign.append(BCCache.getAppID()).append(transactionId).append(transactionType).append(channelType).append(transactionFee);
        boolean isVerified = MD5.verify(toSign.toString(), signature, masterKey, "UTF-8");
        return isVerified;
    }

    public static String generateSignature(String transactionId, String transactionType, String channelType, String transactionFee) {
        StringBuffer toSign = new StringBuffer();
        toSign.append(BCCache.getAppID()).append(transactionId).append(transactionType).append(channelType).append(transactionFee);
        if (StrUtil.empty(toSign)) {
            return "";
        }
        String mysign2 = DigestUtils.md5Hex((byte[])MD5.getContentBytes(toSign.toString(), "UTF-8"));
        return mysign2;
    }

    private static void buildPayParam(Map<String, Object> param, BCOrder para) {
        param.put("app_id", BCCache.getAppID());
        param.put("timestamp", System.currentTimeMillis());
        if (BCCache.isSandbox()) {
            param.put("app_sign", BCUtilPrivate.getAppSignatureWithTestSecret(StrUtil.toStr(param.get("timestamp"))));
        } else {
            param.put("app_sign", BCUtilPrivate.getAppSignature(StrUtil.toStr(param.get("timestamp"))));
        }
        param.put("channel", StrUtil.toStr((Object)para.getChannel()));
        param.put("total_fee", para.getTotalFee());
        param.put("bill_no", para.getBillNo());
        param.put("title", para.getTitle());
        if (para.getReturnUrl() != null) {
            param.put("return_url", para.getReturnUrl());
        }
        if (para.getOptional() != null && para.getOptional().size() > 0) {
            param.put("optional", para.getOptional());
        }
        if (para.getAnalysis() != null && para.getAnalysis().size() > 0) {
            param.put("analysis", para.getAnalysis());
        }
        if (para.getOpenId() != null) {
            param.put("openid", para.getOpenId());
        }
        if (para.getIdentityId() != null) {
            param.put("identity_id", para.getIdentityId());
        }
        if (para.getShowUrl() != null) {
            param.put("show_url", para.getShowUrl());
        }
        if (para.getQrPayMode() != null) {
            if (para.getQrPayMode().ordinal() == 2) {
                param.put("qr_pay_mode", String.valueOf(para.getQrPayMode().ordinal() + 1));
            } else {
                param.put("qr_pay_mode", String.valueOf(para.getQrPayMode().ordinal()));
            }
        }
        if (para.getBillTimeout() != null) {
            param.put("bill_timeout", para.getBillTimeout());
        }
        if (para.getChannel().equals((Object)BCEumeration.PAY_CHANNEL.YEE_NOBANKCARD)) {
            param.put("cardno", para.getCardNo());
            param.put("cardpwd", para.getCardPwd());
            param.put("frqid", para.getFrqid());
        }
        if (para.getGatewayBank() != null) {
            param.put("bank", StrUtil.toStr(para.getGatewayBank()));
        }
        if (para.getBcExpressCardNo() != null) {
            param.put("card_no", StrUtil.toStr(para.getBcExpressCardNo()));
        }
        if (para.getLimitCredit() != null) {
            param.put("limit_credit", (boolean)para.getLimitCredit());
        }
        if (para.isUseApp() != null) {
            param.put("use_app", para.isUseApp());
        }
        if (para.getNotifyUrl() != null) {
            param.put("notify_url", para.getNotifyUrl());
        }
        if (para.getAuthCode() != null) {
            param.put("auth_code", para.getAuthCode());
        }
        if (para.getIdNo() != null) {
            param.put("id_no", para.getIdNo());
        }
        if (para.getIdHolder() != null) {
            param.put("id_holder", para.getIdHolder());
        }
        if (para.getPayType() != null) {
            param.put("pay_type", para.getPayType());
        }
        if (para.getBuyerId() != null) {
            param.put("buyer_id", para.getBuyerId());
        }
        if (para.getCardType() != null) {
            param.put("card_type", para.getCardType());
        }
        if (para.getStoreId() != null) {
            param.put("store_id", para.getStoreId());
        }
    }

    private static void buildBCTransferParam(Map<String, Object> param, BCTransferParameter para) {
        param.put("app_id", BCCache.getAppID());
        param.put("timestamp", System.currentTimeMillis());
        if (BCCache.isSandbox()) {
            param.put("app_sign", BCUtilPrivate.getAppSignatureWithTestSecret(StrUtil.toStr(param.get("timestamp"))));
        } else {
            param.put("app_sign", BCUtilPrivate.getAppSignature(StrUtil.toStr(param.get("timestamp"))));
        }
        param.put("total_fee", para.getTotalFee());
        param.put("bill_no", para.getBillNo());
        param.put("title", para.getTitle());
        param.put("trade_source", para.getTradeSource());
        param.put("bank_fullname", para.getBankFullName());
        param.put("card_type", para.getCardType());
        param.put("account_type", para.getAccountType());
        param.put("account_no", para.getAccountNo());
        param.put("account_name", para.getAccountName());
        if (!StrUtil.empty(para.getNotifyUrl())) {
            param.put("notify_url", para.getNotifyUrl());
        }
        if (!StrUtil.empty(para.getMobile())) {
            param.put("mobile", para.getBankFullName());
        }
        if (!StrUtil.empty(para.getOptional())) {
            param.put("optional", para.getOptional());
        }
    }

    private static void buildBCT0TransferParam(Map<String, Object> param, BCT0TransferParameter para) {
        param.put("app_id", BCCache.getAppID());
        param.put("withdraw_amount", para.getTotalFee());
        param.put("bill_no", para.getBillNo());
        param.put("note", para.getNote());
        param.put("transfer_type", para.getTransferType());
        param.put("bank_name", para.getBankName());
        param.put("bank_account_no", para.getBankAccountNo());
        param.put("bank_account_name", para.getBankAccountName());
        param.put("bank_code", para.getBankCode());
        param.put("signature", BCUtilPrivate.masterSign(BCCache.getAppID() + para.getBillNo() + para.getTotalFee() + para.getBankAccountNo()));
        if (!StrUtil.empty(para.getNotifyUrl())) {
            param.put("notify_url", para.getNotifyUrl());
        }
        if (!StrUtil.empty(para.getOptional())) {
            param.put("optional", para.getOptional());
        }
    }

    private static void buildBCUserTransferParam(Map<String, Object> param, BCTransferParameter para) {
        param.put("app_id", BCCache.getAppID());
        param.put("timestamp", System.currentTimeMillis());
        if (BCCache.isSandbox()) {
            param.put("app_sign", BCUtilPrivate.getAppSignatureWithTestSecret(StrUtil.toStr(param.get("timestamp"))));
        } else {
            param.put("app_sign", BCUtilPrivate.getAppSignature(StrUtil.toStr(param.get("timestamp"))));
        }
        param.put("total_fee", para.getTotalFee());
        param.put("bill_no", para.getBillNo());
        param.put("title", para.getTitle());
        param.put("trade_source", para.getTradeSource());
        param.put("bank_fullname", para.getBankFullName());
        param.put("card_type", para.getCardType());
        param.put("channel", para.getChannel());
        param.put("account_type", para.getAccountType());
        param.put("account_no", para.getAccountNo());
        param.put("account_name", para.getAccountName());
        if (!StrUtil.empty(para.getMobile())) {
            param.put("mobile", para.getBankFullName());
        }
        if (!StrUtil.empty(para.getOptional())) {
            param.put("optional", para.getOptional());
        }
    }

    private static void buildRefundParam(Map<String, Object> param, BCRefund para) {
        param.put("app_id", BCCache.getAppID());
        param.put("timestamp", System.currentTimeMillis());
        param.put("app_sign", BCUtilPrivate.getAppSignatureWithMasterSecret(StrUtil.toStr(param.get("timestamp"))));
        param.put("refund_no", para.getRefundNo());
        param.put("bill_no", para.getBillNo());
        param.put("refund_fee", para.getRefundFee());
        if (para.getChannel() != null) {
            param.put("channel", StrUtil.toStr((Object)para.getChannel()));
        }
        if (para.isNeedApproval() != null) {
            param.put("need_approval", para.isNeedApproval());
        }
        if (para.getOptional() != null && para.getOptional().size() > 0) {
            param.put("optional", para.getOptional());
        }
        param.put("refund_account", para.getRefund_account());
    }

    private static void buildQueryParam(Map<String, Object> param, BCQueryParameter para) {
        param.put("app_id", BCCache.getAppID());
        param.put("timestamp", System.currentTimeMillis());
        if (BCCache.isSandbox()) {
            param.put("app_sign", BCUtilPrivate.getAppSignatureWithTestSecret(StrUtil.toStr(param.get("timestamp"))));
        } else {
            param.put("app_sign", BCUtilPrivate.getAppSignature(StrUtil.toStr(param.get("timestamp"))));
        }
        if (para.getChannel() != null) {
            param.put("channel", StrUtil.toStr((Object)para.getChannel()));
        }
        if (para.getBillNo() != null) {
            param.put("bill_no", para.getBillNo());
        }
        if (para.getRefundNo() != null) {
            param.put("refund_no", para.getRefundNo());
        }
        if (para.getSkip() != null) {
            param.put("skip", para.getSkip());
        }
        if (para.getLimit() != null) {
            param.put("limit", para.getLimit());
        }
        if (para.getStartTime() != null) {
            param.put("start_time", para.getStartTime().getTime());
        }
        if (para.getEndTime() != null) {
            param.put("end_time", para.getEndTime().getTime());
        }
        if (para.getPayResult() != null) {
            param.put("spay_result", para.getPayResult());
        }
        if (para.getRefundResult() != null) {
            param.put("refund_result", para.getRefundResult());
        }
        if (para.getNeedDetail() != null && para.getNeedDetail().booleanValue()) {
            param.put("need_detail", para.getNeedDetail());
        }
        if (para.getNeedApproval() != null && para.getNeedApproval().booleanValue()) {
            param.put("need_approval", para.getNeedApproval());
        }
    }

    private static void buildQueryCountParam(Map<String, Object> param, BCQueryParameter para) {
        param.put("app_id", BCCache.getAppID());
        param.put("timestamp", System.currentTimeMillis());
        if (BCCache.isSandbox()) {
            param.put("app_sign", BCUtilPrivate.getAppSignatureWithTestSecret(StrUtil.toStr(param.get("timestamp"))));
        } else {
            param.put("app_sign", BCUtilPrivate.getAppSignature(StrUtil.toStr(param.get("timestamp"))));
        }
        if (para.getChannel() != null) {
            param.put("channel", StrUtil.toStr((Object)para.getChannel()));
        }
        if (para.getBillNo() != null) {
            param.put("bill_no", para.getBillNo());
        }
        if (para.getRefundNo() != null) {
            param.put("refund_no", para.getRefundNo());
        }
        if (para.getStartTime() != null) {
            param.put("start_time", para.getStartTime().getTime());
        }
        if (para.getEndTime() != null) {
            param.put("end_time", para.getEndTime().getTime());
        }
        if (para.getPayResult() != null) {
            param.put("spay_result", para.getPayResult());
        }
        if (para.getRefundResult() != null) {
            param.put("refund_result", para.getRefundResult());
        }
        if (para.getNeedApproval() != null && para.getNeedApproval().booleanValue()) {
            param.put("need_approval", para.getNeedApproval());
        }
    }

    private static void buildQueryOfflineStatusParam(Map<String, Object> param, String bill_no, BCEumeration.PAY_CHANNEL channel) {
        param.put("app_id", BCCache.getAppID());
        param.put("timestamp", System.currentTimeMillis());
        param.put("app_sign", BCUtilPrivate.getAppSignature(StrUtil.toStr(param.get("timestamp"))));
        param.put("bill_no", bill_no);
        if (channel != null) {
            param.put("channel", channel.toString());
        }
    }

    private static void buildInternatioalPayParam(Map<String, Object> param, BCInternationlOrder order) {
        param.put("app_id", BCCache.getAppID());
        param.put("timestamp", System.currentTimeMillis());
        param.put("app_sign", BCUtilPrivate.getAppSignature(StrUtil.toStr(param.get("timestamp"))));
        param.put("channel", StrUtil.toStr((Object)order.getChannel()));
        param.put("currency", StrUtil.toStr((Object)order.getCurrency()));
        param.put("bill_no", order.getBillNo());
        param.put("title", order.getTitle());
        param.put("total_fee", order.getTotalFee());
        if (order.getCreditCardInfo() != null) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            param.put("credit_card_info", map);
            map.put("card_number", order.getCreditCardInfo().getCardNo());
            map.put("expire_month", order.getCreditCardInfo().getExpireMonth());
            map.put("expire_year", order.getCreditCardInfo().getExpireYear());
            map.put("cvv", order.getCreditCardInfo().getCvv());
            map.put("first_name", order.getCreditCardInfo().getFirstName());
            map.put("last_name", order.getCreditCardInfo().getLastName());
            map.put("card_type", StrUtil.toStr((Object)order.getCreditCardInfo().getCardType()));
        }
        if (order.getCreditCardId() != null) {
            param.put("credit_card_id", order.getCreditCardId());
        }
        if (order.getReturnUrl() != null) {
            param.put("return_url", order.getReturnUrl());
        }
    }

    private static void buildTransferParam(Map<String, Object> param, TransferParameter para) {
        param.put("app_id", BCCache.getAppID());
        param.put("timestamp", System.currentTimeMillis());
        param.put("app_sign", BCUtilPrivate.getAppSignatureWithMasterSecret(StrUtil.toStr(param.get("timestamp"))));
        param.put("channel", StrUtil.toStr((Object)para.getChannel()));
        param.put("transfer_no", para.getTransferNo());
        param.put("total_fee", para.getTotalFee());
        param.put("desc", para.getDescription());
        param.put("channel_user_id", para.getChannelUserId());
        if (para.getChannelUserName() != null) {
            param.put("channel_user_name", para.getChannelUserName());
        }
        if (para.getRedpackInfo() != null) {
            HashMap<String, String> redpackInfo = new HashMap<String, String>();
            redpackInfo.put("send_name", para.getRedpackInfo().getSendName());
            redpackInfo.put("wishing", para.getRedpackInfo().getWishing());
            redpackInfo.put("act_name", para.getRedpackInfo().getActivityName());
            param.put("redpack_info", redpackInfo);
        }
        if (para.getAccountName() != null) {
            param.put("account_name", para.getAccountName());
        }
    }

    private static void buildTransfersParam(Map<String, Object> param, TransfersParameter para) {
        param.put("app_id", BCCache.getAppID());
        param.put("timestamp", System.currentTimeMillis());
        param.put("app_sign", BCUtilPrivate.getAppSignatureWithMasterSecret(StrUtil.toStr(param.get("timestamp"))));
        param.put("channel", StrUtil.toStr((Object)para.getChannel()));
        param.put("batch_no", para.getBatchNo());
        param.put("account_name", para.getAccountName());
        ArrayList transferList = new ArrayList();
        for (ALITransferData data : para.getTransferDataList()) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("transfer_id", data.getTransferId());
            map.put("receiver_account", data.getReceiverAccount());
            map.put("receiver_name", data.getReceiverName());
            map.put("transfer_fee", data.getTransferFee());
            map.put("transfer_note", data.getTransferNote());
            transferList.add(map);
        }
        param.put("transfer_data", transferList);
    }

    private static void buildAuthParam(Map<String, Object> param, BCAuth auth) {
        param.put("app_id", BCCache.getAppID());
        param.put("timestamp", System.currentTimeMillis());
        param.put("app_sign", BCUtilPrivate.getAppSignature(StrUtil.toStr(param.get("timestamp"))));
        param.put("name", StrUtil.toStr(auth.getName()));
        param.put("id_no", StrUtil.toStr(auth.getIdNo()));
        param.put("card_no", StrUtil.toStr(auth.getCardNo()));
        if (auth.getMobile() != null) {
            param.put("mobile", StrUtil.toStr(auth.getMobile()));
        }
    }

    private static List<BCOrder> generateBCOrderList(List<Map<String, Object>> bills) {
        ArrayList<BCOrder> bcOrderList = new ArrayList<BCOrder>();
        for (Map<String, Object> bill : bills) {
            BCOrder bcOrder = new BCOrder();
            BCPay.generateBCOrderBean(bill, bcOrder);
            bcOrderList.add(bcOrder);
        }
        return bcOrderList;
    }

    private static BCOrder generateBCOrder(Map<String, Object> bill) {
        BCOrder bcOrder = new BCOrder();
        BCPay.generateBCOrderBean(bill, bcOrder);
        return bcOrder;
    }

    private static List<BCRefund> generateBCRefundList(List<Map<String, Object>> refundList) {
        ArrayList<BCRefund> bcRefundList = new ArrayList<BCRefund>();
        for (Map<String, Object> refund : refundList) {
            BCRefund bcRefund = new BCRefund();
            BCPay.generateBCRefundBean(refund, bcRefund);
            bcRefundList.add(bcRefund);
        }
        return bcRefundList;
    }

    private static BCRefund generateBCRefund(Map<String, Object> refund) {
        BCRefund bcRefund = new BCRefund();
        BCPay.generateBCRefundBean(refund, bcRefund);
        return bcRefund;
    }

    private static void generateBCOrderBean(Map<String, Object> bill, BCOrder bcOrder) {
        bcOrder.setObjectId(StrUtil.toStr(bill.get("id")));
        bcOrder.setBillNo(StrUtil.toStr(bill.get("bill_no")));
        bcOrder.setTotalFee((Integer)bill.get("total_fee"));
        bcOrder.setTitle(StrUtil.toStr(bill.get("title")));
        bcOrder.setChannel(BCEumeration.PAY_CHANNEL.valueOf(StrUtil.toStr(bill.get("sub_channel"))));
        bcOrder.setResult((Boolean)bill.get("spay_result"));
        if (bill.containsKey("trade_no") && bill.get("trade_no") != null) {
            bcOrder.setChannelTradeNo(StrUtil.toStr(bill.get("trade_no")));
        }
        bcOrder.setOptionalString(StrUtil.toStr(bill.get("optional")));
        bcOrder.setDateTime(BCUtilPrivate.transferDateFromLongToString((Long)bill.get("create_time")));
        if (bill.containsKey("message_detail")) {
            bcOrder.setMessageDetail(StrUtil.toStr(bill.get("message_detail")));
        }
        bcOrder.setRefundResult((Boolean)bill.get("refund_result"));
        bcOrder.setRevertResult((Boolean)bill.get("revert_result"));
    }

    private static void generateBCRefundBean(Map<String, Object> refund, BCRefund bcRefund) {
        bcRefund.setObjectId(StrUtil.toStr(refund.get("id")));
        bcRefund.setBillNo(StrUtil.toStr(refund.get("bill_no")));
        bcRefund.setChannel(BCEumeration.PAY_CHANNEL.valueOf(StrUtil.toStr(refund.get("sub_channel"))));
        bcRefund.setFinished((Boolean)refund.get("finish"));
        bcRefund.setDateTime(BCUtilPrivate.transferDateFromLongToString((Long)refund.get("create_time")));
        bcRefund.setOptionalString(StrUtil.toStr(refund.get("optional")));
        bcRefund.setRefunded((Boolean)refund.get("result"));
        bcRefund.setTitle(StrUtil.toStr(refund.get("title")));
        bcRefund.setTotalFee((Integer)refund.get("total_fee"));
        bcRefund.setRefundFee((Integer)refund.get("refund_fee"));
        bcRefund.setRefundNo(StrUtil.toStr(refund.get("refund_no")));
        if (refund.containsKey("message_detail")) {
            bcRefund.setMessageDetail(StrUtil.toStr(refund.get("message_detail")));
        }
    }

    private static Map<String, String> generateWXJSAPIMap(Map<String, Object> ret) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("appId", StrUtil.toStr(ret.get("app_id")));
        map.put("package", StrUtil.toStr(ret.get("package")));
        map.put("nonceStr", StrUtil.toStr(ret.get("nonce_str")));
        map.put("timeStamp", StrUtil.toStr(ret.get("timestamp")));
        map.put("paySign", StrUtil.toStr(ret.get("pay_sign")));
        map.put("signType", StrUtil.toStr(ret.get("sign_type")));
        return map;
    }

    private static void placeOrder(BCOrder order, Map<String, Object> ret) {
        order.setObjectId(StrUtil.toStr(ret.get("id")));
        order.setResultMap(ret);
        switch (order.getChannel()) {
            case WX_JSAPI: 
            case BC_WX_JSAPI: {
                order.setWxJSAPIMap(BCPay.generateWXJSAPIMap(ret));
                break;
            }
            case BC_ALI_JSAPI: {
                if (!ret.containsKey("trade_no") || null == ret.get("trade_no")) break;
                order.setTradeNo(StrUtil.toStr(ret.get("trade_no")));
                break;
            }
            default: {
                if (ret.containsKey("code_url") && null != ret.get("code_url")) {
                    order.setCodeUrl(StrUtil.toStr(ret.get("code_url")));
                }
                if (ret.containsKey("url") && null != ret.get("url")) {
                    order.setUrl(StrUtil.toStr(ret.get("url")));
                }
                if (ret.containsKey("html") && null != ret.get("html")) {
                    order.setHtml(StrUtil.toStr(ret.get("html")));
                }
                if (StrUtil.empty(order.getUrl()) && !StrUtil.empty(order.getCodeUrl())) {
                    order.setUrl(order.getCodeUrl());
                }
                if (!StrUtil.empty(order.getCodeUrl()) || StrUtil.empty(order.getUrl())) break;
                order.setCodeUrl(order.getUrl());
            }
        }
        if (ret.containsKey("token")) {
            order.setToken(StrUtil.toStr(ret.get("token")));
        }
    }

    private static void placeOfflineOrder(BCOrder order, Map<String, Object> ret) {
        order.setObjectId(StrUtil.toStr(ret.get("id")));
        boolean payResult = (Boolean)ret.get("pay_result");
        if (payResult) {
            order.setResult(true);
        }
    }

    private static void placePayPalOrder(BCInternationlOrder order, Map<String, Object> ret) {
        order.setObjectId(StrUtil.toStr(ret.get("id")));
        switch (order.getChannel()) {
            case PAYPAL_PAYPAL: {
                order.setUrl(StrUtil.toStr(ret.get("url")));
                break;
            }
            case PAYPAL_CREDITCARD: {
                order.setCreditCardId(StrUtil.toStr(ret.get("credit_card_id")));
                break;
            }
        }
    }

    private static void placeSandboxOrder(BCOrder order, Map<String, Object> ret) {
        order.setObjectId(StrUtil.toStr(ret.get("id")));
        switch (order.getChannel()) {
            case WX_NATIVE: {
                if (!ret.containsKey("url") || null == ret.get("url")) break;
                order.setCodeUrl(StrUtil.toStr(ret.get("url")));
                break;
            }
            case WX_JSAPI: {
                order.setWxJSAPIMap(BCPay.generateWXJSAPIMap(ret));
                break;
            }
            case ALI_WEB: 
            case ALI_QRCODE: 
            case ALI_WAP: {
                if (!ret.containsKey("url") || null == ret.get("url")) break;
                order.setHtml(BCUtil.generateSandboxHtmlWithUrl(StrUtil.toStr(ret.get("url"))));
                order.setUrl(StrUtil.toStr(ret.get("url")));
                break;
            }
            case UN_WEB: 
            case UN_WAP: 
            case JD_WAP: 
            case JD_WEB: 
            case KUAIQIAN_WAP: 
            case KUAIQIAN_WEB: 
            case BC_GATEWAY: {
                if (!ret.containsKey("url") || null == ret.get("url")) break;
                order.setHtml(BCUtil.generateSandboxHtmlWithUrl(StrUtil.toStr(ret.get("url"))));
                break;
            }
            case YEE_WAP: 
            case YEE_WEB: 
            case BD_WEB: 
            case BD_WAP: {
                if (!ret.containsKey("url") || null == ret.get("url")) break;
                order.setUrl(StrUtil.toStr(ret.get("url")));
            }
        }
    }

    private static void placeAuth(BCAuth auth, Map<String, Object> ret) {
        if (ret.containsKey("auth_result") && null != ret.get("auth_result")) {
            auth.setAuthResult((Boolean)ret.get("auth_result"));
        }
        if (ret.containsKey("auth_msg") && null != ret.get("auth_msg")) {
            auth.setAuthMsg(StrUtil.toStr(ret.get("auth_msg")));
        }
        if (ret.containsKey("card_id") && null != ret.get("card_id")) {
            auth.setCardId(StrUtil.toStr(ret.get("card_id")));
        }
    }

    private static void buildGateWayBanksParam(Map<String, Object> param, BCGateWayBanks para) {
        param.put("app_id", BCCache.getAppID());
        param.put("timestamp", System.currentTimeMillis());
        param.put("app_sign", BCUtilPrivate.getAppSignature(StrUtil.toStr(param.get("timestamp"))));
        if (para.getCardType() != null) {
            param.put("card_type", StrUtil.toStr(para.getCardType()));
        }
        if (para.getPayType() != null) {
            param.put("pay_type", para.getPayType());
        }
    }

    private static void buildTransferBanksParam(Map<String, Object> param, BCTransferBanks para) {
        param.put("app_id", BCCache.getAppID());
        param.put("timestamp", System.currentTimeMillis());
        param.put("app_sign", BCUtilPrivate.getAppSignature(StrUtil.toStr(param.get("timestamp"))));
        if (para.getType() != null) {
            param.put("type", StrUtil.toStr(para.getType()));
        }
    }

    private static void checkTestModeSwitch() throws BCException {
        if (BCCache.isSandbox()) {
            throw new BCException(-2, BCEumeration.RESULT_TYPE.OTHER_ERROR.name(), TEST_MODE_SUPPORT_ERROR);
        }
    }

    public static List<String> getGateWayBanks(BCGateWayBanks para) throws BCException {
        HashMap<String, Object> param = new HashMap<String, Object>();
        BCPay.buildGateWayBanksParam(param, para);
        Map<String, Object> ret = RequestUtil.doGet(BCUtilPrivate.getGateWayBankListUrl(), param);
        return (List)ret.get("banks");
    }

    public static List<String> getTransferBanks(BCTransferBanks para) throws BCException {
        HashMap<String, Object> param = new HashMap<String, Object>();
        BCPay.buildTransferBanksParam(param, para);
        Map<String, Object> ret = RequestUtil.doGet(BCUtilPrivate.getTransferBankListUrl(), param);
        return (List)ret.get("banks");
    }

    private static void buildBillConfirmParam(Map<String, Object> param, BCBillConfirm para) {
        param.put("app_id", BCCache.getAppID());
        param.put("timestamp", System.currentTimeMillis());
        if (BCCache.isSandbox()) {
            param.put("app_sign", BCUtilPrivate.getAppSignatureWithTestSecret(StrUtil.toStr(param.get("timestamp"))));
        } else {
            param.put("app_sign", BCUtilPrivate.getAppSignature(StrUtil.toStr(param.get("timestamp"))));
        }
        param.put("token", para.getToken());
        param.put("bc_bill_id", para.getBillId());
        param.put("verify_code", para.getVerifyCode());
    }
}

