package com.bambooclod.epasswork.http;

import com.bambooclod.epassbase.bean.BaseResponse;
import com.bambooclod.epassbase.bean.EncrypteData;

import io.reactivex.Observable;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.POST;
import retrofit2.http.Path;

/**
 * Comment: 移动自服务接口定义
 *
 * @author Vangelis.Wang in BambooCloud
 * @date 2019-06-17
 * Email:wangpei@bamboocloud.cn
 */
public interface WorkService {

    /**
     * 地址上下文
     */
    String CONTEXT_NAME = "/epass-api";

    /**
     * 校验Jwt是否有效
     */
    String verifyJwt = CONTEXT_NAME + "/api/jwt/verify";

    /**
     * 查询子账号
     */
    String selectSubAccount = CONTEXT_NAME + "/api/v3/getChildUsersByApp";

    /**
     * 获取加密串
     */
    String getEncryptString = CONTEXT_NAME + "/api/v3/getEncryptedStringByApp";

    /**
     * 获取AM的token值
     */
    String getAMToken = CONTEXT_NAME + "/api/v3/getAMToken";

    /**
     * 非加密通用接口
     * <p>
     * 注释：encoded是为了防止请求地址出现“%2F”这样的转义字符
     *
     * @param appID 应用ID
     * @return BaseResponse<Object>
     */
    @POST("{url}")
    Observable<BaseResponse<Object>> commonRequest(@Path(value = "url", encoded = true) String url, @Body Object appID);

    /**
     * 加密通用接口
     *
     * @param appID 应用ID
     * @return EncrypteData
     */
    @POST("{url}")
    Observable<EncrypteData> commonRequestByEncrypt(@Path(value = "url", encoded = true) String url, @Body Object appID);

    /**
     * 非加密通用接口 -- GET
     * <p>
     * 注释：encoded是为了防止请求地址出现“%2F”这样的转义字符
     *
     * @return BaseResponse<Object>
     */
    @GET("{url}")
    Observable<BaseResponse<Object>> commonRequestByGet(@Path(value = "url", encoded = true) String url);

    /**
     * 非加密通用接口 -- GET
     * <p>
     * 注释：encoded是为了防止请求地址出现“%2F”这样的转义字符
     *
     * @return BaseResponse<Object>
     */
    @GET("{url}")
    Observable<EncrypteData> commonRequestEncryptByGet(@Path(value = "url", encoded = true) String url);

}
