package com.bambooclod.epasswork;

import android.content.Context;

import com.bambooclod.epassbase.config.InitConfigValue;
import com.bambooclod.epassbase.sp.SPUtils;
import com.bambooclod.epasswork.callback.RequestListener;

/**
 * Comment: 工作台
 *
 * @author Vangelis.Wang in BambooCloud
 * @date 2019-07-03
 * Email:wangpei@bamboocloud.cn
 */
public class EpassWorkSDK {

    public static final EpassWorkSDK eaccount = new EpassWorkSDK();

    public static EpassWorkSDK Builder() {
        return eaccount;
    }

    /**
     * 校验Jwt是否合法
     */
    public void verifyJwt(final Context context, RequestListener listener) {
        EpassWorkRequest.get().verifyJwt(context, listener);
    }

    /**
     * 获取Jwt内容
     */
    public String getJwtString(Context context) {
        return EpassWorkRequest.get().getJwtString(context);
    }

    /**
     * 查询子账号
     *
     * @param context  Context
     * @param subAppId 子账号ID
     */
    public void querySubAccount(Context context, String subAppId, final RequestListener listener) {
        EpassWorkRequest.get().querySubAccount(context, subAppId, listener);
    }

    /**
     * 获取加密串
     *
     * @param context    Context
     * @param subAccount 子账号
     */
    public void getEncryptString(Context context, String appID, String subAccount, final RequestListener listener) {
        EpassWorkRequest.get().getEncryptString(context, appID, subAccount, listener);
    }

    /**
     * 设置JWT
     *
     * @param context Context
     * @param jwt     Jwt
     */
    public void setJwtString(Context context, String jwt) {
        if ("".equals(jwt) || jwt == null) {
            SPUtils.put(context, InitConfigValue.USER_JWT, InitConfigValue.DEFAULT);
            return;
        }

        SPUtils.put(context, InitConfigValue.USER_JWT, jwt);
    }

    /**
     * 获取AM的Token只
     * @param context context
     * @param listener listener
     */
    public void getAmToken(Context context,RequestListener listener) {
        EpassWorkRequest.get().getAmToken(context,listener);
    }

}
