package com.bambooclod.epasswork;

import android.content.Context;

import com.bambooclod.epasswork.callback.RequestListener;

/**
 * Comment: 工作台
 *
 * @author Vangelis.Wang in BambooCloud
 * @date 2019-07-03
 * Email:wangpei@bamboocloud.cn
 */
public class EpassWorkSDK {

    public static final EpassWorkSDK eaccount = new EpassWorkSDK();

    public static EpassWorkSDK Builder() {
        return eaccount;
    }

    /**
     * 校验Jwt是否合法
     */
    public void verifyJwt(final Context context, RequestListener listener) {
        EpassWorkRequest.get().verifyJwt(context, listener);
    }

    /**
     * 获取Jwt内容
     */
    public String getJwtString(Context context) {
        return EpassWorkRequest.get().getJwtString(context);
    }

}
