package com.bambooclod.epassself.http;

import com.bambooclod.epassbase.bean.BaseResponse;
import com.bambooclod.epassbase.bean.EncrypteData;

import io.reactivex.Observable;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.POST;
import retrofit2.http.Path;

/**
 * Comment: 移动自服务接口定义
 *
 * @author Vangelis.Wang in BambooCloud
 * @date 2019-06-17
 * Email:wangpei@bamboocloud.cn
 */
public interface SelfService {

    /**
     * 地址上下文
     */
    String CONTEXT_NAME = "/epass-api";

    /**
     * 获取会话详情
     */
    String getViewTokenDetail = CONTEXT_NAME + "/api/v3/session/viewTokenDetail";

    /**
     * 注销会话列表
     */
    String logoutSession = CONTEXT_NAME + "/api/v3/session/logOffSession";

    /**
     * 修改设备指纹备注
     */
    String modifyDeviceRemark = CONTEXT_NAME + "/api/v3/outDevice/update";

    /**
     * 获取信任设备列表
     */
    String getDeviceList = CONTEXT_NAME + "/api/v3/outDevice/list";

    /**
     * 删除信任设备
     */
    String deleteDeviceList = CONTEXT_NAME + "/api/v3/outDevice/delete";

    /**
     * 获取用户信息
     */
    String getUserInfo = CONTEXT_NAME + "/api/v3/user/userInfo";

    /**
     * 修改用户密码
     */
    String modifyUserPassword = CONTEXT_NAME + "/api/v3/user/userPwdUpdate";

    /**
     * 修改用户手势密码
     */
    String modifyUserGesturePassword = CONTEXT_NAME + "/api/v3/user/authinfo/updateGesturePassword";

    /**
     * 用于忘记密码的发送短信认证码
     */
    String sendVerCodeForForgotPwd = CONTEXT_NAME + "/api/v3/user/sendVerificationCode";

    /**
     * 通过短信验证码渠道更新密码
     */
    String updatePwdFromVerCode = CONTEXT_NAME + "/api/v3/user/userPwdUpdateByVerificationCode";

    /**
     * 删除手势密码
     */
    String deleteGesturePassword = CONTEXT_NAME + "/api/v3/user/authinfo/removeGesturePassword";

    /**
     * 保存手势密码
     */
    String saveGesturePassword = CONTEXT_NAME + "/api/v3/user/authinfo/saveGesturePassword";

    /**
     * 新增声纹信息
     */
    String addVoice = CONTEXT_NAME + "/api/v3/userInfo/voiceInfoAdd";

    /**
     * 删除声纹信息
     */
    String deleteVoice = CONTEXT_NAME + "/api/v3/userInfo/voiceInfoDelete";

    /**
     * 新增人脸信息
     */
    String addFace = CONTEXT_NAME + "/api/v3/userInfo/faceInfoAdd";

    /**
     * 删除人脸信息
     */
    String deleteFace = CONTEXT_NAME + "/api/v3/userInfo/faceInfoDelete";

    /**
     * 获取认证状态
     */
    String getAuthStatus = CONTEXT_NAME + "/api/v3/user/authinfo/viewStatus";

    /**
     * 通过随机串和设备指纹获取用户名
     */
    String getUserNameByEncryptString = CONTEXT_NAME + "/api/v3/getUserName";

    /**
     * 非加密通用接口
     * <p>
     * 注释：encoded是为了防止请求地址出现“%2F”这样的转义字符
     *
     * @param appID 应用ID
     * @return BaseResponse<Object>
     */
    @POST("{url}")
    Observable<BaseResponse<Object>> commonRequest(@Path(value = "url", encoded = true) String url, @Body Object appID);

    /**
     * 加密通用接口
     *
     * @param appID 应用ID
     * @return EncrypteData
     */
    @POST("{url}")
    Observable<EncrypteData> commonRequestByEncrypt(@Path(value = "url", encoded = true) String url, @Body Object appID);

    /**
     * 非加密通用接口 -- GET
     * <p>
     * 注释：encoded是为了防止请求地址出现“%2F”这样的转义字符
     *
     * @return BaseResponse<Object>
     */
    @GET("{url}")
    Observable<BaseResponse<Object>> commonRequestByGet(@Path(value = "url", encoded = true) String url);

    /**
     * 非加密通用接口 -- GET
     * <p>
     * 注释：encoded是为了防止请求地址出现“%2F”这样的转义字符
     *
     * @return BaseResponse<Object>
     */
    @GET("{url}")
    Observable<EncrypteData> commonRequestEncryptByGet(@Path(value = "url", encoded = true) String url);

}
