package com.bambooclod.epassself.api;

import android.content.Context;

import com.bambooclod.epassself.callback.CommonResultListener;
import com.bambooclod.epassself.callback.GetAuthTypeStatusListener;
import com.bambooclod.epassself.callback.GetTrustDeviceListListener;
import com.bambooclod.epassself.callback.GetUserInfoListener;
import com.bambooclod.epassself.callback.GetViewTokenListener;

import java.util.List;

/**
 * Comment: 自服务SDK
 *
 * @author Vangelis.Wang in BambooCloud
 * @date 2019-07-03
 * Email:wangpei@bamboocloud.cn
 */
public class EpassSelfSDK {

    public static final EpassSelfSDK eaccount = new EpassSelfSDK();

    public static EpassSelfSDK Builder() {
        return eaccount;
    }

    /**
     * 获取会话列表
     *
     * @param context  Context
     * @param listener 回调
     */
    public void getViewTokens(final Context context, final GetViewTokenListener listener){
        EpassSelfRequest.get().getViewTokens(context,listener);
    }

    /**
     * 注销会话
     *
     * @param context  Context
     * @param listener 回调
     */
    public void logoutSession(final Context context,String tokenKey,final CommonResultListener listener){
        EpassSelfRequest.get().logoutSession(context,tokenKey,listener);
    }

    /**
     * 获取认证状态
     */
    public void getAuthStatus(final Context context, final GetAuthTypeStatusListener listener){
        EpassSelfRequest.get().getAuthStatus(context,listener);
    }

    /**
     * 获取信任设备列表
     */
    public void getTrustDevices(Context context, String pageSize, String page
            , final GetTrustDeviceListListener listener){
        EpassSelfRequest.get().getTrustDevices(context,pageSize,page,listener);
    }

    /**
     * 修改默认设备备注
     *
     * @param context Context
     * @param id      设备ID
     * @param remarks 新的备注
     */
    public void modifyTrustDeviceRemark(final Context context, String id, String remarks
            , final CommonResultListener listener){
        EpassSelfRequest.get().modifyTrustDeviceRemark(context,id,remarks,listener);
    }

    /**
     * 删除信任设备
     *
     * @param context  Context
     * @param id       设备ID
     * @param tokenID  TokenID
     * @param listener 回调
     */
    public void deleteTrustDevice(final Context context, String id, String tokenID
            , final CommonResultListener listener){
        EpassSelfRequest.get().deleteTrustDevice(context,id,tokenID,listener);
    }

    /**
     * 获取用户信息
     *
     * @param context  Context
     * @param listener 回调
     */
    public void getUserInfo(final Context context, int isForceLoad
            , final GetUserInfoListener listener){
        EpassSelfRequest.get().getUserInfo(context,isForceLoad,listener);
    }

    /**
     * 修改用户密码
     *
     * @param context     Context
     * @param oldPassword 旧密码
     * @param password    新密码
     * @param listener    回调
     */
    public void modifyPassword(final Context context, String oldPassword, String password
            , final CommonResultListener listener){
        EpassSelfRequest.get().modifyPassword(context,oldPassword,password,listener);
    }

    /**
     * 修改手势密码
     *
     * @param context  Context
     * @param listener 回调
     */
    public void modifyGesturePassword(final Context context, String gesture, String newGestureData
            , final CommonResultListener listener){
        EpassSelfRequest.get().modifyGesturePassword(context,gesture,newGestureData,listener);
    }

    /**
     * 新增手势密码
     *
     * @param context  Context
     * @param gesture  手势密码
     * @param listener 回调
     */
    public void saveGesturePassword(final Context context, String gesture
            , final CommonResultListener listener){
        EpassSelfRequest.get().saveGesturePassword(context,gesture,listener);
    }

    /**
     * 新增声纹信息
     * 需要3次
     *
     * @param context      Context
     * @param readContents 读取的内容
     * @param audioDatas   声纹信息（arm格式，base64编码）
     * @param listener     回调
     */
    public void addVoice(final Context context, List<String> readContents, List<String> audioDatas
            , final CommonResultListener listener){
        EpassSelfRequest.get().addVoice(context,readContents,audioDatas,listener);
    }

    /**
     * 删除声纹信息
     *
     * @param context  Context
     * @param listener 回调
     */
    public void deleteVoice(final Context context, final CommonResultListener listener){
        EpassSelfRequest.get().deleteVoice(context,listener);
    }

    /**
     * 新增人脸数据
     * <p>
     * 说明：只有新增的时候需要传递3张人脸照片
     *
     * @param context  Context
     * @param datas    人脸数据
     * @param listener 回调
     */
    public void addFace(final Context context, List<String> datas, final CommonResultListener listener){
        EpassSelfRequest.get().addFace(context,datas,listener);
    }

    /**
     * 删除人脸数据
     *
     * @param context  Context
     * @param listener 回调
     */
    public void deleteFace(final Context context, final CommonResultListener listener){
        EpassSelfRequest.get().deleteFace(context,listener);
    }

    /**
     * 在忘记密码的情况下，发送短信验证码
     *
     * @param context  Context
     * @param phone    手机号码
     * @param listener 回调
     */
    public void sendVerCodeForForgotPWD(final Context context, String phone
            , final CommonResultListener listener){
        EpassSelfRequest.get().sendVerCodeForForgotPWD(context,phone,listener);
    }

    /**
     * 重置密码 -- 忘记密码情况
     *
     * @param context     Context
     * @param newPassword 新密码
     * @param phone       手机号
     * @param verCode     验证码
     * @param listener    回调
     */
    public void updatePwdByVerCode(final Context context, String newPassword, String phone
            , String verCode, final CommonResultListener listener){
        EpassSelfRequest.get().updatePwdByVerCode(context,newPassword,phone,verCode,listener);
    }

    /**
     * 删除手势密码
     *
     * @param context    Context
     * @param gestureNum 手势密码
     * @param listener   回调
     */
    public void deleteGesturePassword(final Context context, String gestureNum
            , final CommonResultListener listener){
        EpassSelfRequest.get().deleteGesturePassword(context,gestureNum,listener);
    }

    /**
     * 使用加密串获取用户信息
     *
     * @param context Context
     * @param encryptString 加密串
     */
    public void getUserNameByEncryptString(final Context context, String encryptString
            , final GetUserInfoListener listener) {
        EpassSelfRequest.get().getUserNameByEncryptString(context,encryptString,listener);
    }
}
