package com.bambooclod.epassbase.otp;

import android.content.Context;

import com.bambooclod.epassbase.config.InitConfigValue;
import com.bambooclod.epassbase.log.LogUtil;
import com.bambooclod.epassbase.sp.SPUtils;

import java.util.Locale;

/**
 * Comment: OTP校验工具类
 *
 * @author Vangelis.Wang in BambooCloud
 * @date 2019-06-10
 * Email:wangpei@bamboocloud.cn
 */
public class OtpUtils {

    /**
     * 初始化otp
     */
    public static void initOtp(Context context, String otpkey) {
        if (!InitConfigValue.DEFAULT.equals(otpkey) && otpkey != null && !"".equals(otpkey)) {
            //添加OTP
            //基于什么  颁发者 用户ID 用户key 算法 口令位数  时间间隔
            String issuer = "123";
            String userId = "123";
            String algorithm = "sha1";
            //OTP位数
            int digits = 6;
            //OTP步长
            int otpStep = (int) SPUtils.get(context, InitConfigValue.USER_OTP_STEP, 30);
            LogUtil.getInstance().i("OTP步长：" + otpStep);
            String uri = String.format(Locale.US,
                    "otpauth://%sotp/%s:%s?secret=%s&algorithm=%s&digits=%d&period=%d",
                    "t", issuer, userId,
                    otpkey, algorithm, digits, otpStep);
            // Add the token
            if (TokenPersistence.addWithToast(context, uri) != null) {
                //令牌注册成功
                SPUtils.put(context, InitConfigValue.USER_OTP_KEY, otpkey);
            }
        }else{
            LogUtil.getInstance().e("OTP有误");
            SPUtils.put(context, InitConfigValue.USER_OTP_KEY, InitConfigValue.DEFAULT);
        }
    }

}
