package com.bambooclod.epassbase.config;

/**
 * Comment: Http请求的配置项
 *
 * @author Vangelis.Wang in BambooCloud
 * @date 2019-06-04
 * Email:wangpei@bamboocloud.cn
 */
public class HttpConfig {

    /**
     * 连接超时限制
     */
    public static final int CONNECT_TIME_OUT = 20;

    /**
     * 读取超时限制
     */
    public static final int READ_TIME_OUT = 20;

    /**
     * 写入超时限制
     */
    public static final int WRITE_TIME_OUT = 20;

    /**
     * 声纹认证类型 -- 随意
     */
    public static final String AUDIO_TYPE_NORMAL = "audio_type_normal";

    /**
     * 声纹认证类型 -- 严格
     */
    public static final String AUDIO_TYPE_STRICT = "audio_type_strict";

    /**
     * 认证类型  --- 在线认证
     */
    public static final String GLOBAL_AUTH_TYPE_ONLINE = "global_auth_type_online";

    /**
     * 认证类型  --- 离线认证
     */
    public static final String GLOBAL_AUTH_TYPE_OFFLINE = "global_auth_type_offline";

    /**
     * 认证类型
     */
    public static class AuthType {

        public static final String FACE = "face";
        public static final String PWD = "pwd";
        public static final String SMS = "sms";
        public static final String OTP = "otp";
        public static final String VOICE = "voice";
        public static final String GESTURE = "gesture";
        public static final String QR = "qr";
        public static final String FR = "fr";
        public static final String NONE = "none";
    }
}
