package com.bambooclod.epassbase.bean;

import android.accounts.NetworkErrorException;
import android.content.Context;
import android.widget.Toast;

import com.alibaba.fastjson.JSON;
import com.bambooclod.epassbase.config.InitConfigValue;
import com.bambooclod.epassbase.http.CleanSaveSessionUtils;
import com.bambooclod.epassbase.log.LogUtil;
import com.bambooclod.epassbase.sp.SPUtils;
import com.bambooclod.epassbase.util.auth.V2SignUtil;

import java.net.ConnectException;
import java.net.UnknownHostException;
import java.util.concurrent.TimeoutException;

import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;

/**
 * Comment: Retrofit请求过程管理 -- 加密数据
 *
 * @author Vangelis.Wang in BambooCloud
 * @date 2019-06-04
 * Email:wangpei@bamboocloud.cn
 */
public abstract class BaseEncryptObserver implements Observer<EncrypteData> {

    protected Context mContext;

    public BaseEncryptObserver(Context cxt) {
        this.mContext = cxt;
    }

    public BaseEncryptObserver() {

    }


    @Override
    public void onSubscribe(Disposable d) {
        onRequestStart();
    }

    @Override
    public void onNext(EncrypteData tBaseResponse) {
        onRequestEnd();
        String authKey = (String) SPUtils.get(mContext, InitConfigValue.KEY_ENCRYPT, InitConfigValue.DEFAULT);
        String decryptData = V2SignUtil.decrypt(tBaseResponse.getU(), authKey);
        BaseResponse<Object> objectBaseResponse = JSON.parseObject(decryptData, BaseResponse.class);

        if (objectBaseResponse == null) {
            return;
        }

        if (objectBaseResponse.isSuccess()) {
            try {
                //这个比较特殊
                //{"code":"user.password.expired.warn","message":"用户密码已过期，请尽快修改，以保证密码安全"}
                if("user.password.expired.warn".equals(objectBaseResponse.getCode())){
                    onCodeError("-1",objectBaseResponse.getMessage(),objectBaseResponse.getBody());
                }
                onSuccess(objectBaseResponse.getBody());
            } catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            try {
                //销毁Session时机
                CleanSaveSessionUtils.get().cleanSaveSession(mContext, objectBaseResponse.getCode(),objectBaseResponse);
                onCodeError(objectBaseResponse.getCode(), objectBaseResponse.getMessage(), objectBaseResponse.getBody());
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void onError(Throwable e) {
        //这里可以打印错误信息
        onRequestEnd();
        try {
            if (e instanceof ConnectException
                    || e instanceof TimeoutException
                    || e instanceof NetworkErrorException
                    || e instanceof UnknownHostException) {
                onFailure(e, true);
            } else {
                onFailure(e, false);
            }
        } catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    @Override
    public void onComplete() {
    }

    /**
     * 返回成功
     */
    protected abstract void onSuccess(Object body) throws Exception;

    /**
     * 返回失败
     *
     * @param isNetWorkError 是否是网络错误
     */
    protected void onFailure(Throwable e, boolean isNetWorkError) {
        LogUtil.getInstance().e("请求错误：" + e.getMessage());
    }

    /**
     * 返回成功了,但是code错误
     */
    protected abstract void onCodeError(String code, String message, Object body);

    /**
     * 请求开始
     */
    protected void onRequestStart() {
    }

    /**
     * 请求结束
     */
    protected void onRequestEnd() {
    }
}
