package com.bambooclod.epassbase.api;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.os.Environment;
import android.os.StatFs;
import android.provider.Settings;
import android.support.annotation.Nullable;
import android.telephony.TelephonyManager;
import android.util.Base64;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;
import android.widget.Toast;

import com.alibaba.fastjson.JSON;
import com.bambooclod.epassbase.bean.JwtDecodeData;
import com.bambooclod.epassbase.config.InitConfigValue;
import com.bambooclod.epassbase.log.LogUtil;
import com.bambooclod.epassbase.sp.SPUtils;
import com.bambooclod.epassbase.util.RandomUtil;
import com.bambooclod.epassbase.util.auth.V2SignUtil;


import java.io.BufferedReader;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.util.UUID;

/**
 * Comment: EPass中的向外提供的工具类
 *
 * @author Vangelis.Wang in BambooCloud
 * @date 2019-06-14
 * Email:wangpei@bamboocloud.cn
 */
public class EpassUtils {

    private EpassUtils() {
    }

    public static final EpassUtils eaccount = new EpassUtils();

    public static EpassUtils get() {
        return eaccount;
    }

    /**
     * 获取设备唯一标识码
     *
     * @param context Context
     */
    public String getDeviceID(Context context) {
        LogUtil.getInstance().d("是否su：" + checkSuFile());
        String deviceID = Settings.System.getString(context.getContentResolver(), Settings.Secure.ANDROID_ID);
        LogUtil.getInstance().d("唯一标识：" + deviceID);
        LogUtil.getInstance().d("判断是否重装的随机码：" + getRandomNumber(context));
        LogUtil.getInstance().d("手机Ram：" + getTotalRam(context));
        LogUtil.getInstance().d("手机SD存储：" + getSDTotalSize() / 1024 / 1024);
        LogUtil.getInstance().d("手机型号：" + Build.MODEL);
        LogUtil.getInstance().d("手机IMEI：" + getIMEI(context));
        LogUtil.getInstance().d("手机CPU：" + android.os.Build.HARDWARE);
        LogUtil.getInstance().d("手机CPU核心数：" + Runtime.getRuntime().availableProcessors());
        LogUtil.getInstance().d("手机手机屏幕信息：" + getDisplayInfo(context));

        boolean isCheckBM = (boolean) SPUtils
                .get(context, InitConfigValue.DEVICE_FR_IS_CHECK_BM, false);
        boolean isCheckRoot = (boolean) SPUtils
                .get(context, InitConfigValue.DEVICE_FR_IS_CHECK_ROOT, false);
        boolean isCheckReInstall = (boolean) SPUtils
                .get(context, InitConfigValue.DEVICE_FR_IS_CHECK_REINSTALL, false);

        String inDeviceID = "";
        if (isCheckBM) {
            LogUtil.getInstance().d("已检测是否刷机");
            inDeviceID = deviceID;
        }

        String isRoot = "";
        if (isCheckRoot) {
            LogUtil.getInstance().d("已检测是否越狱");
            isRoot = checkSuFile() + "";
        }

        String isReInstall = "";
        if (isCheckReInstall) {
            LogUtil.getInstance().d("已检测是否重装");
            isReInstall = getRandomNumber(context);
        }

        //生成因子
        String format = getIMEI(context) + inDeviceID + isRoot + isReInstall
                + getTotalRam(context) + getSDTotalSize() + Build.MODEL
                + android.os.Build.HARDWARE + Runtime.getRuntime().availableProcessors();

        UUID uuid = UUID.nameUUIDFromBytes(format.getBytes());
        LogUtil.getInstance().d("最后的设备指纹为：" + uuid.toString());
        return uuid.toString();
    }

    /**
     * 获取内部随机码
     * <p>
     * 只要不重装应用，就不会发生改变
     */
    private String getRandomNumber(Context context) {
        String randomNum = (String) SPUtils.get(context, InitConfigValue.APP_RANDOM_NUMBER, InitConfigValue.DEFAULT);
        if (InitConfigValue.DEFAULT.equals(randomNum)) {
            randomNum = RandomUtil.getNumRandomString(10);
            SPUtils.put(context, InitConfigValue.APP_RANDOM_NUMBER, randomNum);
        }

        return randomNum;
    }

    /**
     * 判断是否SU及Root
     */
    private boolean checkSuFile() {
        Process process = null;
        try {
            //   /system/xbin/which 或者  /system/bin/which
            process = Runtime.getRuntime().exec(new String[]{"which", "su"});
            BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));
            return in.readLine() != null;
        } catch (Throwable t) {
            return false;
        } finally {
            if (process != null) process.destroy();
        }
    }

    /**
     * 获取手机Ram信息
     */
    private static String getTotalRam(Context context) {//GB
        String path = "/proc/meminfo";
        String firstLine = null;
        int totalRam = 0;
        try {
            FileReader fileReader = new FileReader(path);
            BufferedReader br = new BufferedReader(fileReader, 8192);
            firstLine = br.readLine().split("\\s+")[1];
            br.close();
        } catch (Exception e) {
            e.printStackTrace();
        }
        if (firstLine != null) {
            totalRam = (int) Math.ceil((Float.valueOf(Float.valueOf(firstLine) / (1024 * 1024)).doubleValue()));
        }

        return totalRam + "GB";//返回1GB/2GB/3GB/4GB
    }

    /**
     * 计算总空间
     */
    private long getTotalSize(String path) {
        StatFs fs = new StatFs(path);
        fs.restat(path);
        return (long) fs.getBlockCount() * fs.getBlockSize();
    }

    /**
     * 获取SD的总空间
     */
    private long getSDTotalSize() {
        if (Environment.getExternalStorageState().equals(Environment.MEDIA_MOUNTED)) {
            return getTotalSize(Environment.getExternalStorageDirectory().toString());
        }

        return 0;
    }

    /**
     * 获取屏幕信息
     */
    private String getDisplayInfo(Context context) {
        WindowManager wm = (WindowManager) context.getSystemService(Context.WINDOW_SERVICE);
        DisplayMetrics displayMetrics = new DisplayMetrics();
        Display defaultDisplay = wm.getDefaultDisplay();
        defaultDisplay.getMetrics(displayMetrics);
        int widthPixels = displayMetrics.widthPixels;
        int heightPixels = displayMetrics.heightPixels;
        float xdpi = displayMetrics.xdpi;
        float ydpi = displayMetrics.ydpi;

        float width2 = (widthPixels / xdpi) * (widthPixels / xdpi);
        float height2 = (heightPixels / ydpi) * (heightPixels / xdpi);

        float x = (float) Math.sqrt(width2 + height2);

        LogUtil.getInstance().d("物理分辨率：w:" + widthPixels + ",h:" + heightPixels);
        LogUtil.getInstance().d("屏幕尺寸:" + x);

        return widthPixels + "-" + heightPixels + "-" + x;
    }

    /**
     * 获取手机IMEI
     */
    private String getIMEI(Context context) {
        try {
            //实例化TelephonyManager对象
            TelephonyManager telephonyManager = (TelephonyManager) context.getSystemService(Context.TELEPHONY_SERVICE);
            //获取IMEI号
            @SuppressLint({"MissingPermission", "HardwareIds"})
            String imei = telephonyManager.getDeviceId();
            //在次做个验证，也不是什么时候都能获取到的啊
            if (imei == null) {
                imei = "";
            }
            return imei;
        } catch (Exception e) {
            e.printStackTrace();
            return "";
        }

    }

    public String getRandomString(int len) {
        return RandomUtil.getNumRandomString(len);
    }

    public String encryt(String val, String authKey) {
        return V2SignUtil.encryt(val, authKey);
    }

    /**
     * 清除用户缓存
     *
     * @param context Contexg
     */
    public void clearUserInfo(Context context) {
        SPUtils.clearUserInfo(context);
    }

    /**
     * 解析Jwt中的内容
     */
    @Nullable
    public JwtDecodeData parseJwtToInfo(Context context) {
        String jwt = (String) SPUtils.get(context, InitConfigValue.USER_JWT, InitConfigValue.DEFAULT);

        if (InitConfigValue.DEFAULT.equals(jwt)) {
            return null;
        }

        String[] forma = jwt.split("\\.");
        String jwtContent = new String(Base64.decode(forma[1], Base64.DEFAULT));
        return JSON.parseObject(jwtContent, JwtDecodeData.class);
    }
}
