package com.bambooclod.epassbase.http;

import android.support.annotation.NonNull;

import com.alibaba.fastjson.JSON;

import okhttp3.MediaType;
import okhttp3.RequestBody;
import retrofit2.Converter;

/**
 * Comment: FastJson请求转换器
 *
 * @author Vangelis.Wang in BambooCloud
 * @date 2019-06-05
 * Email:wangpei@bamboocloud.cn
 */

public class FastJsonRequestBodyConverter<T> implements Converter<T, RequestBody> {
    private static final MediaType MEDIA_TYPE = MediaType.parse("application/json; charset=UTF-8");

    @Override
    public RequestBody convert(@NonNull T value) {
        return RequestBody.create(MEDIA_TYPE, JSON.toJSONBytes(value));
    }
}
