package com.bambooclod.epassbase.http;

import android.content.Context;

import com.alibaba.fastjson.JSON;
import com.bambooclod.epassbase.bean.AdditionalAuthData;
import com.bambooclod.epassbase.bean.BaseResponse;
import com.bambooclod.epassbase.config.InitConfigValue;
import com.bambooclod.epassbase.log.LogUtil;
import com.bambooclod.epassbase.sp.SPUtils;

/**
 * Comment: 内部存储和清除Session工具类
 *
 * @author Vangelis.Wang in BambooCloud
 * @date 2019-07-04
 * Email:wangpei@bamboocloud.cn
 */
public class CleanSaveSessionUtils {

    private CleanSaveSessionUtils() {
    }

    public static final CleanSaveSessionUtils eaccount = new CleanSaveSessionUtils();

    public static CleanSaveSessionUtils get() {
        return eaccount;
    }

    /**
     * 系统错误：会话状态校验失败，请传递jwt或者token
     */
    private static final String SYSTEM_ERROR_JWT_TOKEN_INVALID = "apiSecurity.sessionControl.jwtOrToken.invalid";
    private static final String APPID_NOT_EXIST = "apiSecurity.sessionControl.appId.notExist";
    private static final String TIME_OUT = "error.session.time.out";
    private static final String JWT_SINGNATURE = "error.dispatchercenter.jwtsignature";
    private static final String TOKEN_SEARCH = "error.dispatchercenter.eptoken.search";
    private static final String SESSION_TIME_OUT = "error.dispatchercenter.eptoken.sessiontimeout";
    private static final String TOKEN_NOT_EXIST = "dispatchcentre.eptoken.not.exist";
    private static final String VERIFY_FAIL = "dispatchcentre.eptoken.verify.fail";
    private static final String SESSION_NOT_EXIST = "dispatchcentre.epsession.not.exist";
    private static final String SESSION_STATE_ERROR = "dispatchcentre.epsession.state.error";
    private static final String ERROR_COUNT_LIMIT = "dispatchcentre.authing.error.count.limit";
    private static final String AUTH_TYPE_DISMATCH = "dispatchcentre.authType.dismatch";
    private static final String IDLE_TIME_BEYOND = "dispatchcentre.authing.idletime.beyond";
    private static final String JWT_ADDITIONAL_AUTH = "error.dispatchercenter.jwt.additional.auth";
    private static final String STATE_ERROR = "error.dispatchcentre.state.error";

    /**
     * 存储Session时机
     *
     * @param code 返回code
     */
    public void cleanSaveSession(Context context, String code, BaseResponse reponse) {
        if (SYSTEM_ERROR_JWT_TOKEN_INVALID.equals(code)
                || APPID_NOT_EXIST.equals(code)
                || TIME_OUT.equals(code)
                || JWT_SINGNATURE.equals(code)
                || TOKEN_SEARCH.equals(code)
                || SESSION_TIME_OUT.equals(code)
                || VERIFY_FAIL.equals(code)
                || SESSION_NOT_EXIST.equals(code)
                || SESSION_STATE_ERROR.equals(code)
                || ERROR_COUNT_LIMIT.equals(code)
                || TOKEN_NOT_EXIST.equals(code)
                || AUTH_TYPE_DISMATCH.equals(code)
                || STATE_ERROR.equals(code)
                || IDLE_TIME_BEYOND.equals(code)) {
            //这两种情况要清除Session
            LogUtil.getInstance().d("服务器发生异常，清除SESSION");
            SPUtils.put(context, InitConfigValue.REQUEST_EP_SESSION, InitConfigValue.DEFAULT);
        }

        //令牌过期，清除JWT及用户数据？
        if(TOKEN_SEARCH.equals(code)){
            SPUtils.clearUserInfo(context);
        }

        if (JWT_ADDITIONAL_AUTH.equals(code)) {
            LogUtil.getInstance().d("获取加密串，存储Session");
            AdditionalAuthData response = JSON.parseObject(reponse.getBody().toString()
                    , AdditionalAuthData.class);
            SPUtils.put(context, InitConfigValue.REQUEST_EP_SESSION, response.getEpsessionid());
        }
    }
}
