package com.bambooclod.epassbase.util.auth;


import com.bambooclod.epassbase.util.MD5Util;
import com.bambooclod.epassbase.util.sm4.Sm4Utils;

/**
 * <p>文件名称: </p>
 * <p>文件描述: </p>
 * <p>版权所有: 版权所有(C)2017</p>
 * <p>公 司: 深圳竹云科技有限公司</p>
 * <p>内容摘要: </p>
 * <p>其他说明: 无</p>
 *
 * @author lwf
 **/
public class V2SignUtil {

    /**
     * 生成鉴权签名加密数据
     * @param operator 鉴权用户名
     * @param authkey 鉴权秘钥
     * @param timestamp 时间戳
     * @param randomstr 随机字符
     */
    public static String encode(String operator, String authkey, Long timestamp, String randomstr){
        return MD5Util.getMD5(operator+randomstr+timestamp+authkey);
    }

    /**
     * 参数签名
     * @param bodyAuthKey 签名秘钥
     * @param bodyStr 签名的参数
     */
    public static String bodySign(String bodyAuthKey,String bodyStr){
        return MD5Util.getMD5(bodyAuthKey+bodyStr);
    }

    /**
     * 请求参数体加密
     * @param val 参数值
     * @param authKey 加密秘钥
     */
    public static String encryt(String val,String authKey){
        Sm4Utils sm4Utils = new Sm4Utils();
        return sm4Utils.encryptData_ECB(val,authKey);
    }

    /**
     * 请求参数体解密
     * @param val 密文
     * @param authKey 解密秘钥
     */
    public static String decrypt(String val,String authKey){
        Sm4Utils sm4Utils = new Sm4Utils();
        return sm4Utils.decryptData_ECB(val,authKey);
    }
}
