package com.bambooclod.epassbase.http;

import android.content.Context;

import com.bambooclod.epassbase.config.HttpConfig;
import com.bambooclod.epassbase.config.InitConfigValue;
import com.bambooclod.epassbase.sp.SPUtils;

import java.util.concurrent.TimeUnit;

import okhttp3.OkHttpClient;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;

/**
 * Comment: Retrofit生成工厂
 *
 * @author Vangelis.Wang in BambooCloud
 * @date 2019-06-04
 * Email:wangpei@bamboocloud.cn
 */
public class RetrofitFactory {

    // TODO: 2019-06-04 考虑全局context
    private static RetrofitFactory mRetrofitFactory;
    private Retrofit mRetrofit;
    private Context mContext;

    private RetrofitFactory(Context context) {
        this.mContext = context;

        String baseUrl = (String) SPUtils.get(mContext, InitConfigValue.BASE_URL, InitConfigValue.DEFAULT);
        Long timeOut = (Long) SPUtils.get(mContext, InitConfigValue.HTTP_REQUEST_TIME_OUT, 5L);

        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        //这里判断是否为Https,如果是则信任所有证书
        if (baseUrl.startsWith("https")) {
            builder.connectTimeout(timeOut, TimeUnit.SECONDS)
                    .readTimeout(HttpConfig.READ_TIME_OUT, TimeUnit.SECONDS)
                    .writeTimeout(HttpConfig.WRITE_TIME_OUT, TimeUnit.SECONDS)
                    .sslSocketFactory(TrustAllCerts.createSSLSocketFactory())
                    .hostnameVerifier(new TrustAllCerts.TrustAllHostnameVerifier())
                    .addInterceptor(new InterceptorUtil(mContext).HeaderInterceptor())
                    .addInterceptor(new InterceptorUtil(mContext).LogInterceptor())//添加日志拦截器
                    .build();
        } else {
            builder.connectTimeout(timeOut, TimeUnit.SECONDS)
                    .readTimeout(HttpConfig.READ_TIME_OUT, TimeUnit.SECONDS)
                    .writeTimeout(HttpConfig.WRITE_TIME_OUT, TimeUnit.SECONDS)
                    .addInterceptor(new InterceptorUtil(mContext).HeaderInterceptor())
                    .addInterceptor(new InterceptorUtil(mContext).LogInterceptor())//添加日志拦截器
                    .build();
        }

        mRetrofit = new Retrofit.Builder()
                .baseUrl(baseUrl)
                .addConverterFactory(FastJsonConverterFactory.create())//添加gson转换器
                .addCallAdapterFactory(RxJava2CallAdapterFactory.create())//添加rxjava转换器
                .client(builder.build())
                .build();
    }

    public static RetrofitFactory getInstance(Context context) {
        if (mRetrofitFactory == null) {
            synchronized (RetrofitFactory.class) {
                if (mRetrofitFactory == null)
                    mRetrofitFactory = new RetrofitFactory(context);
            }

        }
        return mRetrofitFactory;
    }

    public Retrofit API() {
        return mRetrofit;
    }
}