package com.bambooclod.epassbase.sp;

import android.content.Context;
import android.content.SharedPreferences;

import com.bambooclod.epassbase.BuildConfig;
import com.bambooclod.epassbase.config.InitConfigValue;
import com.bambooclod.epassbase.log.LogUtil;
import com.bambooclod.epassbase.util.auth.V2SignUtil;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;

/**
 * Comment: SP工具类
 *
 * @author Vangelis.Wang in BambooCloud
 * @date 2019-06-04
 * Email:wangpei@bamboocloud.cn
 */
public class SPUtils {
    /**
     * 保存在手机里面的文件名
     */
    public static final String FILE_NAME = "bamboocloud_eaccount3";

    /**
     * 保存数据的方法，我们需要拿到保存数据的具体类型，然后根据类型调用不同的保存方法
     */
    public static void put(Context context, String key, Object object) {

        SharedPreferences sp = context.getSharedPreferences(FILE_NAME,
                Context.MODE_PRIVATE);
        SharedPreferences.Editor editor = sp.edit();

        if (object instanceof String) {
            String encrytString = V2SignUtil.encryt((String) object, BuildConfig.Sp_Salt_Value);
            LogUtil.getInstance().e("加密 ：" + encrytString);
            //国密加密
            editor.putString(key, encrytString);
        } else if (object instanceof Integer) {
            editor.putInt(key, (Integer) object);
        } else if (object instanceof Boolean) {
            editor.putBoolean(key, (Boolean) object);
        } else if (object instanceof Float) {
            editor.putFloat(key, (Float) object);
        } else if (object instanceof Long) {
            editor.putLong(key, (Long) object);
        } else {
            editor.putString(key, object.toString());
        }

        SharedPreferencesCompat.apply(editor);
    }

    /**
     * 查询是否加密内容
     */
    public static boolean isEncrytContent(Context context) {
        //是否内容加密
        return (boolean) SPUtils.get(context, InitConfigValue.BODY_IS_ENCRYPT
                , false);
    }

    /**
     * 查询是否签名内容
     */
    public static boolean isSignContent(Context context) {
        //是否内容加密
        return (boolean) SPUtils.get(context, InitConfigValue.BODY_IS_SIGN
                , false);
    }

    /**
     * 查询是否检查会话
     */
    public static boolean isCheckSession(Context context) {
        //是否内容加密
        return (boolean) SPUtils.get(context, InitConfigValue.BODY_IS_CHECK_SESSION
                , false);
    }

    /**
     * 得到保存数据的方法，我们根据默认值得到保存的数据的具体类型，然后调用相对于的方法获取值
     */
    public static Object get(Context context, String key, Object defaultObject) {
        SharedPreferences sp = context.getSharedPreferences(FILE_NAME,
                Context.MODE_PRIVATE);

        if (defaultObject instanceof String) {
            String result = sp.getString(key, (String) defaultObject);
            LogUtil.getInstance().e("解密 ：" + result);
            if (result.isEmpty() || InitConfigValue.DEFAULT.equals(result)) {
                return InitConfigValue.DEFAULT;
            } else {
                String decryptString = V2SignUtil.decrypt(result, BuildConfig.Sp_Salt_Value);
                LogUtil.getInstance().e("解密后 ：" + decryptString);
                return decryptString;
            }
        } else if (defaultObject instanceof Integer) {
            return sp.getInt(key, (Integer) defaultObject);
        } else if (defaultObject instanceof Boolean) {
            return sp.getBoolean(key, (Boolean) defaultObject);
        } else if (defaultObject instanceof Float) {
            return sp.getFloat(key, (Float) defaultObject);
        } else if (defaultObject instanceof Long) {
            return sp.getLong(key, (Long) defaultObject);
        }

        return InitConfigValue.DEFAULT;
    }

    /**
     * 移除某个key值已经对应的值
     */
    public static void remove(Context context, String key) {
        SharedPreferences sp = context.getSharedPreferences(FILE_NAME,
                Context.MODE_PRIVATE);
        SharedPreferences.Editor editor = sp.edit();
        editor.remove(key);
        SharedPreferencesCompat.apply(editor);
    }

    /**
     * 清除所有数据
     */
    public static void clear(Context context) {
        SharedPreferences sp = context.getSharedPreferences(FILE_NAME,
                Context.MODE_PRIVATE);
        SharedPreferences.Editor editor = sp.edit();
        editor.clear();
        SharedPreferencesCompat.apply(editor);
    }

    /**
     * 移除用户信息
     */
    public static void clearUserInfo(Context context) {
        SharedPreferences sp = context.getSharedPreferences(FILE_NAME,
                Context.MODE_PRIVATE);
        Map<String, Object> map = (Map<String, Object>) sp.getAll();
        for (String key : map.keySet()) {
            if (InitConfigValue.USER_JWT.equals(key)) {
                LogUtil.getInstance().d("移除USER_JWT");
                remove(context, key);
            } else if (InitConfigValue.USER_OTP_KEY.equals(key)) {
                LogUtil.getInstance().d("移除USER_OTP_KEY");
                remove(context, key);
            } else if (InitConfigValue.USER_OTP_STEP.equals(key)) {
                LogUtil.getInstance().d("移除USER_OTP_STEP");
                remove(context, key);
            } else if (InitConfigValue.REQUEST_EP_SESSION.equals(key)) {
                LogUtil.getInstance().d("移除REQUEST_EP_SESSION");
                remove(context, key);
            }
        }
    }

    /**
     * 查询某个key是否已经存在
     */
    public static boolean contains(Context context, String key) {
        SharedPreferences sp = context.getSharedPreferences(FILE_NAME,
                Context.MODE_PRIVATE);
        return sp.contains(key);
    }

    /**
     * 返回所有的键值对
     */
    public static Map<String, ?> getAll(Context context) {
        SharedPreferences sp = context.getSharedPreferences(FILE_NAME,
                Context.MODE_PRIVATE);
        return sp.getAll();
    }

    /**
     * 创建一个解决SharedPreferencesCompat.apply方法的一个兼容类
     */
    private static class SharedPreferencesCompat {
        private static final Method sApplyMethod = findApplyMethod();

        /**
         * 反射查找apply的方法
         */
        private static Method findApplyMethod() {
            try {
                Class clz = SharedPreferences.Editor.class;
                return clz.getMethod("apply");
            } catch (NoSuchMethodException e) {
                e.printStackTrace();
            }

            return null;
        }

        /**
         * 如果找到则使用apply执行，否则使用commit
         */
        public static void apply(SharedPreferences.Editor editor) {
            try {
                if (sApplyMethod != null) {
                    sApplyMethod.invoke(editor);
                    return;
                }
            } catch (IllegalArgumentException e) {
                e.printStackTrace();
            } catch (IllegalAccessException e) {
                e.printStackTrace();
            } catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            editor.commit();
        }
    }

}
