package com.bambooclod.epassbase.config;

/**
 * Comment: 调用方传入的参数的内部Key
 *
 * @author Vangelis.Wang in BambooCloud
 * @date 2019-06-04
 * Email:wangpei@bamboocloud.cn
 */
public class InitConfigValue {

    /**
     * 后台地址
     */
    public static final String BASE_URL = "bambooclound_base_url";

    /**
     * 请求Http内容是否加密
     */
    public static final String BODY_IS_ENCRYPT = "bambooclound_body_is_encrypt";

    /**
     * 请求Http内容是否签名
     */
    public static final String BODY_IS_SIGN = "bambooclound_body_is_sign";

    /**
     * Http是否开启会话
     */
    public static final String BODY_IS_CHECK_SESSION = "bambooclound_body_is_check_session";

    /**
     * 接口鉴权参数
     */
    public static final String USER_OPERATOR = "bambooclound_user_operator";

    /**
     * AppID
     */
    public static final String APP_ID = "bambooclound_app_id";

    /**
     * 内部Jwt
     */
    public static final String USER_JWT = "bambooclound_jwt";

    /**
     * 内部OTP Ley
     */
    public static final String USER_OTP_KEY = "bambooclound_user_otpkey";

    /**
     * OTP生成的步长
     */
    public static final String USER_OTP_STEP = "bambooclound_user_otp_step";

    /**
     * SP的默认值
     */
    public static final String DEFAULT = "";

    /**
     * 判断应用是否重装的标识码
     */
    public static final String APP_RANDOM_NUMBER = "bambooclound_app_random_number";

    /**
     * 设备指纹的生成是否需要检测刷机
     */
    public static final String DEVICE_FR_IS_CHECK_BM = "bambooclound_is_check_bm";

    /**
     * 设备指纹的生成是否需要检测越狱
     */
    public static final String DEVICE_FR_IS_CHECK_ROOT = "bambooclound_is_check_root";

    /**
     * 设备指纹的生成是否需要检测是否重装应用
     */
    public static final String DEVICE_FR_IS_CHECK_REINSTALL = "bambooclound_is_check_reinstall";

    /**
     * 鉴权秘钥
     */
    public static final String KEY_AUTH = "bambooclound_key_auth";

    /**
     * 签名秘钥
     */
    public static final String KEY_SIGN = "bambooclound_key_sign";

    /**
     * 加密秘钥
     */
    public static final String KEY_ENCRYPT = "bambooclound_key_encrypt";

    /**
     * 声纹注册的时候，重复次数
     */
    public static final String VOICE_REG_REPEAT_COUNT = "bambooclound_voice_reg_repeat_count";

    /**
     * 人脸注册的时候，重复次数
     */
    public static final String FACE_REG_REPEAT_COUNT = "bambooclound_face_reg_repeat_count";

    /**
     * 存储SESSION
     */
    public static final String REQUEST_EP_SESSION = "bambooclound_request_ep_session";

    /**
     * 声纹认证的类型：
     * <p>
     * 严格或者随意模式
     */
    public static final String AUDIO_AUTH_TYPE = "bambooclound_audio_auth_type";

    /**
     * 声纹录音倒计时
     */
    public static final String AUDIO_RECORD_COUNTDOWN = "bambooclound_audio_record_countdown";

    /**
     * Http请求超时时间
     */
    public static final String HTTP_REQUEST_TIME_OUT = "bambooclound_http_request_time_out";

    /**
     * 认证类型
     * <p>
     * 分为本地认证和在线认证，具体为：
     * <p>
     * 1.指纹单次认证
     * 2.手势新增、删除、修改，改为本地缓存手势密码
     * 3.手势单次认证，改为到本地缓存校验手势密码
     * <p>
     * Default默认为在线认证方式
     */
    public static final String GLOBAL_AUTH_TYPE = "bambooclound_global_auth_type";

    /**
     * 存储离线认证模式下存储手势密码
     * <p>
     * 注意：这里要携带用户名一起存储，不然全部都统一一个手势密码了
     */
    public static final String OFFLINE_GESTURE_PASSWORD = "bambooclound_global_auth_type";

    /**
     * 离线模式下的用户名指定
     */
    public static final String OFFLINE_USER_NAME = "bambooclound_offline_user_name";
}
