package com.bambooclod.epassbase.api;

import android.content.Context;

import com.bambooclod.epassbase.config.InitConfigValue;
import com.bambooclod.epassbase.http.RetrofitFactory;
import com.bambooclod.epassbase.log.CrashHandler;
import com.bambooclod.epassbase.log.LogUtil;
import com.bambooclod.epassbase.otp.OtpUtils;
import com.bambooclod.epassbase.sp.SPUtils;
import com.bambooclod.epassbase.util.RandomUtil;
import com.bambooclod.epassbase.util.auth.V2SignUtil;


/**
 * Comment: 对外调用类
 *
 * @author Vangelis.Wang in BambooCloud
 * @date 2019-06-04
 * Email:wangpei@bamboocloud.cn
 */
public class EpassBaseSDK {

    /**
     * OTP步长
     */
    private int mOtpStep = 30;
    private Context mContext;

    private EpassBaseSDK() {
    }

    // TODO: 2019-06-24 内存泄漏问题
    public static final EpassBaseSDK eaccount = new EpassBaseSDK();

    public static EpassBaseSDK Builder() {
        return eaccount;
    }

    /**
     * 初始化后台地址
     */
    public EpassBaseSDK setBaseUrl(String baseUrl) {
        if ("".equals(baseUrl)) {
            throw new NullPointerException("后台地址不能为空!");
        } else {
            //初始化的时候,查看是否已经初始化了
            if (SPUtils.contains(mContext, InitConfigValue.BASE_URL)) {
                LogUtil.getInstance().e("已初始化,无法再次初始化");
            } else {
                SPUtils.put(mContext, InitConfigValue.BASE_URL, baseUrl);
            }
        }
        return this;
    }

    /**
     * 更新后台地址
     */
    public void updateBaseUrl(String baseUrl) {
        if ("".equals(baseUrl)) {
            throw new NullPointerException("后台地址不能为空!");
        } else {
            SPUtils.put(mContext, InitConfigValue.BASE_URL, baseUrl);
        }
    }

    /**
     * 是否开启检查会话
     */
    public EpassBaseSDK isCheckSession(boolean checkSession) {
        if (SPUtils.contains(mContext, InitConfigValue.BODY_IS_CHECK_SESSION)) {
            LogUtil.getInstance().e("已初始化,无法再次初始化");
        } else {
            SPUtils.put(mContext, InitConfigValue.BODY_IS_CHECK_SESSION, checkSession);
        }
        return this;
    }

    /**
     * 更新是否开启检查会话
     */
    public void updateIsCheckSession(boolean checkSession) {
        SPUtils.put(mContext, InitConfigValue.BODY_IS_CHECK_SESSION, checkSession);
    }

    /**
     * 是否开启内容加密传输
     */
    public EpassBaseSDK isEncrypt(boolean encrypt) {
        if (SPUtils.contains(mContext, InitConfigValue.BODY_IS_ENCRYPT)) {
            LogUtil.getInstance().e("已初始化,无法再次初始化");
        } else {
            SPUtils.put(mContext, InitConfigValue.BODY_IS_ENCRYPT, encrypt);
        }
        return this;
    }

    /**
     * 更新是否开启内容加密传输
     */
    public void updateIsEncrypt(boolean encrypt) {
        SPUtils.put(mContext, InitConfigValue.BODY_IS_ENCRYPT, encrypt);
    }

    /**
     * 设置认证类型
     */
    public EpassBaseSDK setAuthType(String type) {
        if (SPUtils.contains(mContext, InitConfigValue.GLOBAL_AUTH_TYPE)) {
            LogUtil.getInstance().e("已初始化,无法再次初始化");
        } else {
            SPUtils.put(mContext, InitConfigValue.GLOBAL_AUTH_TYPE, type);
        }
        return this;
    }

    /**
     * 更新认证类型
     */
    public void updateAuthType(String type) {
        SPUtils.put(mContext, InitConfigValue.GLOBAL_AUTH_TYPE, type);
    }

    /**
     * 是否开启内容签名
     */
    public EpassBaseSDK isSign(boolean sign) {
        if (SPUtils.contains(mContext, InitConfigValue.BODY_IS_SIGN)) {
            LogUtil.getInstance().e("已初始化,无法再次初始化");
        } else {
            SPUtils.put(mContext, InitConfigValue.BODY_IS_SIGN, sign);
        }
        return this;
    }

    /**
     * 更新开启内容签名
     */
    public void updateIsSign(boolean sign) {
        SPUtils.put(mContext, InitConfigValue.BODY_IS_SIGN, sign);
    }

    /**
     * 设置OTP步长
     */
    public EpassBaseSDK setOtpStep(int step) {
        if (SPUtils.contains(mContext, InitConfigValue.USER_OTP_STEP)) {
            LogUtil.getInstance().e("已初始化,无法再次初始化");
        } else {
            SPUtils.put(mContext, InitConfigValue.USER_OTP_STEP, mOtpStep);
            updateOtp(mContext);
        }
        return this;
    }

    /**
     * 更新OTP步长
     */
    public void updateOtpStep(int step) {
        SPUtils.put(mContext, InitConfigValue.USER_OTP_STEP, mOtpStep);
        updateOtp(mContext);
    }

    /**
     * 设置是否检测刷机
     */
    public EpassBaseSDK isBrushMachine(boolean bm) {
        if (SPUtils.contains(mContext, InitConfigValue.DEVICE_FR_IS_CHECK_BM)) {
            LogUtil.getInstance().e("已初始化,无法再次初始化");
        } else {
            SPUtils.put(mContext, InitConfigValue.DEVICE_FR_IS_CHECK_BM, bm);
        }
        return this;
    }

    /**
     * 更新是否检测刷机
     */
    public void updateBrushMachine(boolean bm) {
        SPUtils.put(mContext, InitConfigValue.DEVICE_FR_IS_CHECK_BM, bm);
    }

    /**
     * 设置是否检测越狱
     */
    public EpassBaseSDK isCheckRoot(boolean root) {
        if (SPUtils.contains(mContext, InitConfigValue.DEVICE_FR_IS_CHECK_ROOT)) {
            LogUtil.getInstance().e("已初始化,无法再次初始化");
        } else {
            SPUtils.put(mContext, InitConfigValue.DEVICE_FR_IS_CHECK_ROOT, root);
        }
        return this;
    }

    /**
     * 设置是否检测越狱
     */
    public void updateCheckRoot(boolean root) {
        SPUtils.put(mContext, InitConfigValue.DEVICE_FR_IS_CHECK_ROOT, root);
    }

    /**
     * 设置是否检测重装应用
     */
    public EpassBaseSDK isCheckReInstall(boolean install) {
        if (SPUtils.contains(mContext, InitConfigValue.DEVICE_FR_IS_CHECK_REINSTALL)) {
            LogUtil.getInstance().e("已初始化,无法再次初始化");
        } else {
            SPUtils.put(mContext, InitConfigValue.DEVICE_FR_IS_CHECK_REINSTALL, install);
        }
        return this;
    }

    /**
     * 更新是否检测重装应用
     */
    public void updateIsCheckReInstall(boolean install) {
        SPUtils.put(mContext, InitConfigValue.DEVICE_FR_IS_CHECK_REINSTALL, install);
    }

    /**
     * 指定鉴权用户
     */
    public EpassBaseSDK setOperator(String operator) {
        if ("".equals(operator)) {
            throw new NullPointerException("鉴权用户不能为空!");
        } else {
            if (SPUtils.contains(mContext, InitConfigValue.USER_OPERATOR)) {
                LogUtil.getInstance().e("已初始化,无法再次初始化");
            } else {
                SPUtils.put(mContext, InitConfigValue.USER_OPERATOR, operator);
            }
        }
        return this;
    }

    /**
     * 更新鉴权用户
     */
    public void updateOperator(String operator) {
        if ("".equals(operator)) {
            throw new NullPointerException("鉴权用户不能为空!");
        } else {
            SPUtils.put(mContext, InitConfigValue.USER_OPERATOR, operator);
        }
    }

    /**
     * 设置AppID
     */
    public EpassBaseSDK setAppID(String appID) {
        if ("".equals(appID)) {
            throw new NullPointerException("AppID不能为空!");
        } else {
            if (SPUtils.contains(mContext, InitConfigValue.APP_ID)) {
                LogUtil.getInstance().e("已初始化,无法再次初始化");
            } else {
                SPUtils.put(mContext, InitConfigValue.APP_ID, appID);
            }
        }
        return this;
    }

    /**
     * 更新AppID
     */
    public void updateAppID(String appID) {
        if ("".equals(appID)) {
            throw new NullPointerException("AppID不能为空!");
        } else {
            SPUtils.put(mContext, InitConfigValue.APP_ID, appID);
        }
    }

    /**
     * 设置声纹录音倒计时
     */
    public EpassBaseSDK setAudioAuthTime(int time) {
        if (time < 3 || time > 20) {
            throw new NullPointerException("声纹认证倒计时不合法!");
        } else {
            if (SPUtils.contains(mContext, InitConfigValue.AUDIO_RECORD_COUNTDOWN)) {
                LogUtil.getInstance().e("已初始化,无法再次初始化");
            } else {
                SPUtils.put(mContext, InitConfigValue.AUDIO_RECORD_COUNTDOWN, time);
            }
        }
        return this;
    }

    /**
     * 更新声纹录音倒计时
     */
    public void updateAudioAuthTime(int time) {
        if (time < 3 || time > 20) {
            throw new NullPointerException("声纹认证倒计时不合法!");
        } else {
            SPUtils.put(mContext, InitConfigValue.AUDIO_RECORD_COUNTDOWN, time);
        }
    }

    /**
     * 设置声纹认证类型
     */
    public EpassBaseSDK setAudioAuthType(String tpye) {
        if ("".equals(tpye)) {
            throw new NullPointerException("声纹认证类型不能为空!");
        } else {
            if (SPUtils.contains(mContext, InitConfigValue.AUDIO_AUTH_TYPE)) {
                LogUtil.getInstance().e("已初始化,无法再次初始化");
            } else {
                SPUtils.put(mContext, InitConfigValue.AUDIO_AUTH_TYPE, tpye);
            }
        }
        return this;
    }

    /**
     * 更新声纹认证类型
     */
    public void updateAudioAuthType(String tpye) {
        if ("".equals(tpye)) {
            throw new NullPointerException("声纹认证类型不能为空!");
        } else {
            SPUtils.put(mContext, InitConfigValue.AUDIO_AUTH_TYPE, tpye);
        }
    }

    /**
     * 设置鉴权秘钥
     */
    public EpassBaseSDK setAuthKey(String authKey) {
        if ("".equals(authKey)) {
            throw new NullPointerException("鉴权秘钥不能为空!");
        } else {
            if (SPUtils.contains(mContext, InitConfigValue.KEY_AUTH)) {
                LogUtil.getInstance().e("已初始化,无法再次初始化");
            } else {
                SPUtils.put(mContext, InitConfigValue.KEY_AUTH, authKey);
            }
        }
        return this;
    }

    /**
     * 更新鉴权秘钥
     */
    public void updateAuthKey(String authKey) {
        if ("".equals(authKey)) {
            throw new NullPointerException("鉴权秘钥不能为空!");
        } else {
            SPUtils.put(mContext, InitConfigValue.KEY_AUTH, authKey);
        }
    }

    /**
     * 设置加密秘钥
     */
    public EpassBaseSDK setEncryptKey(String encryptKey) {
        if ("".equals(encryptKey)) {
            throw new NullPointerException("加密秘钥不能为空!");
        } else {
            if (SPUtils.contains(mContext, InitConfigValue.KEY_ENCRYPT)) {
                LogUtil.getInstance().e("已初始化,无法再次初始化");
            } else {
                SPUtils.put(mContext, InitConfigValue.KEY_ENCRYPT, encryptKey);
            }
        }
        return this;
    }

    /**
     * 更新加密秘钥
     */
    public void updateEncryptKey(String encryptKey) {
        if ("".equals(encryptKey)) {
            throw new NullPointerException("加密秘钥不能为空!");
        } else {
            SPUtils.put(mContext, InitConfigValue.KEY_ENCRYPT, encryptKey);
        }
    }

    /**
     * 设置签名秘钥
     */
    public EpassBaseSDK setSign(String sign) {
        if ("".equals(sign)) {
            throw new NullPointerException("签名秘钥不能为空!");
        } else {
            if (SPUtils.contains(mContext, InitConfigValue.KEY_SIGN)) {
                LogUtil.getInstance().e("已初始化,无法再次初始化");
            } else {
                SPUtils.put(mContext, InitConfigValue.KEY_SIGN, sign);
            }
        }
        return this;
    }

    /**
     * 更新签名秘钥
     */
    public void updateSign(String sign) {
        if ("".equals(sign)) {
            throw new NullPointerException("签名秘钥不能为空!");
        } else {
            SPUtils.put(mContext, InitConfigValue.KEY_SIGN, sign);
        }
    }

    /**
     * 设置声纹注册训练次数
     */
    public EpassBaseSDK setVoiceRegCount(int count) {
        if (SPUtils.contains(mContext, InitConfigValue.VOICE_REG_REPEAT_COUNT)) {
            LogUtil.getInstance().e("已初始化,无法再次初始化");
        } else {
            SPUtils.put(mContext, InitConfigValue.VOICE_REG_REPEAT_COUNT, count);
        }
        return this;
    }

    /**
     * 更新声纹注册训练次数
     */
    public void updateVoiceRegCount(int count) {
        SPUtils.put(mContext, InitConfigValue.VOICE_REG_REPEAT_COUNT, count);
    }

    /**
     * 设置人脸注册训练次数
     */
    public EpassBaseSDK setFaceRegCount(int count) {
        if (SPUtils.contains(mContext, InitConfigValue.FACE_REG_REPEAT_COUNT)) {
            LogUtil.getInstance().e("已初始化,无法再次初始化");
        } else {
            SPUtils.put(mContext, InitConfigValue.FACE_REG_REPEAT_COUNT, count);
        }
        return this;
    }

    /**
     * 更新人脸注册训练次数
     */
    public void updateFaceRegCount(int count) {
        SPUtils.put(mContext, InitConfigValue.FACE_REG_REPEAT_COUNT, count);
    }

    /**
     * 设置Http请求超时时间
     */
    public EpassBaseSDK setHttpRequestTimeOut(long time) {
        if (SPUtils.contains(mContext, InitConfigValue.HTTP_REQUEST_TIME_OUT)) {
            LogUtil.getInstance().e("已初始化,无法再次初始化");
        } else {
            SPUtils.put(mContext, InitConfigValue.HTTP_REQUEST_TIME_OUT, time);
        }
        return this;
    }

    /**
     * 更新Http请求超时时间
     */
    public void updateHttpRequestTimeOut(long time) {
        SPUtils.put(mContext, InitConfigValue.HTTP_REQUEST_TIME_OUT, time);
    }

    /**
     * 获取服务器地址
     */
    public String getBaseUrl(Context context) {
        return (String) SPUtils.get(context, InitConfigValue.BASE_URL, InitConfigValue.DEFAULT);
    }

    /**
     * 获取鉴权秘钥
     */
    public String getAuthKey(Context context) {
        return (String) SPUtils.get(context, InitConfigValue.KEY_AUTH, InitConfigValue.DEFAULT);
    }

    /**
     * 获取加密秘钥
     */
    public String getEncryptKey(Context context) {
        return (String) SPUtils.get(context, InitConfigValue.KEY_ENCRYPT, InitConfigValue.DEFAULT);
    }

    /**
     * 获取请求超时时间
     */
    public Long getRequestTimeOut(Context context) {
        return (Long) SPUtils.get(context, InitConfigValue.HTTP_REQUEST_TIME_OUT, 5L);
    }

    /**
     * 获取离线用户名
     */
    public String getLocalUserName(Context context) {
        return (String) SPUtils.get(context, InitConfigValue.OFFLINE_USER_NAME, InitConfigValue.DEFAULT);
    }

    /**
     * 获取签名秘钥
     */
    public String getSignKey(Context context) {
        return (String) SPUtils.get(context, InitConfigValue.KEY_SIGN, InitConfigValue.DEFAULT);
    }

    /**
     * 初始化功能在这里写
     */
    public EpassBaseSDK init(Context context) {
        LogUtil.getInstance().e("初始化成功");
        this.mContext = context;

        //清空session
        LogUtil.getInstance().d("初始化的时候，清除SESSION");
        SPUtils.put(context, InitConfigValue.REQUEST_EP_SESSION, InitConfigValue.DEFAULT);

        updateOtp(context);

        //初始化错误抓取工具
        CrashHandler.getInstance().init(context);

        return this;
    }

    /**
     * 更新OTP Key刷新配置
     */
    private void updateOtp(Context context) {
        //重新指定步长后，应该重新刷新配置
        String localOtpKey = (String) SPUtils.get(context, InitConfigValue.USER_OTP_KEY
                , InitConfigValue.DEFAULT);
        if (!InitConfigValue.DEFAULT.equals(localOtpKey) && localOtpKey != null) {
            OtpUtils.initOtp(context, localOtpKey);
        }
    }

    /**
     * 设置离线模式的用户名
     *
     * @param userName 用户名
     */
    public void setLocalUserName(String userName) {
        SPUtils.put(mContext, InitConfigValue.OFFLINE_USER_NAME, userName);
    }

    /**
     * 获取设备唯一标识码
     *
     * @param context Context
     */
    public String getDeviceID(Context context) {
        return EpassUtils.get().getDeviceID(context);
    }

    /**
     * 获取随机字符
     */
    public String getRandomString(int len) {
        return RandomUtil.getNumRandomString(len);
    }

    public String encryt(String val, String authKey) {
        return V2SignUtil.encryt(val, authKey);
    }

    public <T> T getAPi(Context context, Class clz) {
        return (T) RetrofitFactory.getInstance(context)
                .API().create(clz);
    }
}
