package com.bambooclod.epassbase.call;

import android.content.Context;

import com.bambooclod.epassbase.api.EpassUtils;
import com.bambooclou.util.RandomUtil;

/**
 * Comment: 基础类
 *
 * @author Vangelis.Wang in BambooCloud
 * @date 2019-06-29
 * Email:wangpei@bamboocloud.cn
 */
public class EpassBase {

    private EpassBase() {
    }

    public static final EpassBase eaccount = new EpassBase();

    public static EpassBase get() {
        return eaccount;
    }

    /**
     * 获取设备唯一标识码
     *
     * @param context Context
     */
    public String getDeviceID(Context context) {
        return EpassUtils.get().getDeviceID(context);
    }

    public String getRandomString(int len) {
        return RandomUtil.getNumRandomString(len);
    }
}
