package com.bambooclod.eaccount3.callback;

/**
 * Comment: 密码认证回调
 *
 * @author Vangelis.Wang in BambooCloud
 * @date 2019-06-05
 * Email:wangpei@bamboocloud.cn
 */
public interface AuthCallBackByMessage {

    /**
     * 统一密码认证成功
     *
     * @param authList   还需认证类型列表
     * @param authedList 已经认证类型列表
     */
    void doAuthSuccess(String authList, String authedList,String message,String code);

    /**
     * 需要进行设备绑定
     *
     * @param authList  需要进行的绑定认证类型
     */
    void needBindDevice(String authList,String message,String code);

    /**
     * 请求出错
     *
     * @param code    服务器返回错误码
     * @param message 服务器提示信息
     */
    void error(String code, String message);
}
