package com.bambooclod.eaccount3.http;

import com.bambooclod.epassbase.bean.BaseResponse;
import com.bambooclod.epassbase.bean.EncrypteData;

import io.reactivex.Observable;
import retrofit2.http.Body;
import retrofit2.http.POST;
import retrofit2.http.Path;

/**
 * Comment: 接口定义
 *
 * @author Vangelis.Wang in BambooCloud
 * @date 2019-06-04
 * Email:wangpei@bamboocloud.cn
 */
public interface ApiService {

    /**
     * 地址上下文
     */
    String CONTEXT_NAME = "/epass-api";

    /**
     * 统一认证接口：提供给Web、APP、PC端，进行各种认证、轮询的统一接口
     */
    String doAuth = CONTEXT_NAME + "/api/auth/doauth";

    /**
     * 认证方式验证接口：提供给第三方系统进行不含认证链的单项认证api接口
     */
    String commonAuth = CONTEXT_NAME + "/api/auth/commonAuth";

    /**
     * 获取短信验证码
     */
    String sendSms = CONTEXT_NAME + "/api/login/sendSMS";

    /**
     * 非加密通用接口
     * <p>
     * 注释：encoded是为了防止请求地址出现“%2F”这样的转义字符
     *
     * @param appID 应用ID
     * @return BaseResponse<Object>
     */
    @POST("{url}")
    Observable<BaseResponse<Object>> commonRequest(@Path(value = "url", encoded = true) String url, @Body Object appID);

    /**
     * 加密通用接口
     *
     * @param appID 应用ID
     * @return EncrypteData
     */
    @POST("{url}")
    Observable<EncrypteData> commonRequestByEncrypt(@Path(value = "url", encoded = true) String url, @Body Object appID);
}
