package com.bambooclod.eaccount3.bean;

import android.support.annotation.NonNull;

/**
 * Comment: 指纹认证的参数体
 *
 * @author Vangelis.Wang in BambooCloud
 * @date 2019-06-06
 * Email:wangpei@bamboocloud.cn
 */
public class FingerAuthPara {

    /**
     * userInfo : {"userId":"admin","loginName":"admin","email":"","mobileNum":"15296562230"}
     * modelId : 123456789
     */

    private UserInfoBean userInfo;
    private String modelId;
    private String deviceBindType = "";
    private String loginName = "";

    public FingerAuthPara() {
    }

    public FingerAuthPara(UserInfoBean userInfo, String modelId) {
        this.userInfo = userInfo;
        this.modelId = modelId;
    }

    public FingerAuthPara(String modelId, String loginName) {
        this.modelId = modelId;
        this.loginName = loginName;
    }

    public UserInfoBean getUserInfo() {
        return userInfo;
    }

    public void setUserInfo(UserInfoBean userInfo) {
        this.userInfo = userInfo;
    }

    public String getModelId() {
        return modelId;
    }

    public void setModelId(String modelId) {
        this.modelId = modelId;
    }

    public FingerAuthPara(UserInfoBean userInfo, String modelId, String deviceBindType) {
        this.userInfo = userInfo;
        this.modelId = modelId;
        this.deviceBindType = deviceBindType;
    }

    public FingerAuthPara(String modelId, String deviceBindType, String loginName) {
        this.modelId = modelId;
        this.deviceBindType = deviceBindType;
        this.loginName = loginName;
    }

    public String getLoginName() {
        return loginName;
    }

    public void setLoginName(String loginName) {
        this.loginName = loginName;
    }

    public String getDeviceBindType() {
        return deviceBindType;
    }

    public void setDeviceBindType(String deviceBindType) {
        this.deviceBindType = deviceBindType;
    }

    public static class UserInfoBean {
        /**
         * userId : admin
         * loginName : admin
         * email :
         * mobileNum : 15296562230
         */

        private String userId;
        private String loginName;
        private String email;
        private String modelId;

        public UserInfoBean(String userId, String loginName, String modelId) {
            this.userId = userId;
            this.loginName = loginName;
            this.modelId = modelId;
        }

        public UserInfoBean() {
        }

        public String getUserId() {
            return userId;
        }

        public void setUserId(String userId) {
            this.userId = userId;
        }

        public String getLoginName() {
            return loginName;
        }

        public void setLoginName(String loginName) {
            this.loginName = loginName;
        }

        public String getEmail() {
            return email;
        }

        public void setEmail(String email) {
            this.email = email;
        }

        public String getModelId() {
            return modelId;
        }

        public void setModelId(String modelId) {
            this.modelId = modelId;
        }

        @NonNull
        @Override
        public String toString() {
            return "UserInfoBean{" +
                    "userId='" + userId + '\'' +
                    ", loginName='" + loginName + '\'' +
                    ", email='" + email + '\'' +
                    ", mobileNum='" + modelId + '\'' +
                    '}';
        }
    }

    @NonNull
    @Override
    public String toString() {
        return "GestureAuthPara{" +
                "userInfo=" + userInfo.toString() +
                ", modelId='" + modelId + '\'' +
                '}';
    }
}
