package com.bambooclod.eaccount3.api;

import android.content.Context;

import com.alibaba.fastjson.JSON;
import com.bambooclod.eaccount3.bean.SendSmsData;
import com.bambooclod.eaccount3.bean.SmsAuthPara;
import com.bambooclod.eaccount3.bean.SmsBindData;
import com.bambooclod.eaccount3.callback.AuthCallBack;
import com.bambooclod.eaccount3.callback.SendSmsCallBack;
import com.bambooclod.eaccount3.callback.SingalAuthCallBack;
import com.bambooclod.eaccount3.http.ApiService;
import com.bambooclod.epassbase.api.EpassBaseSDK;
import com.bambooclod.epassbase.bean.BaseEncryptObserver;
import com.bambooclod.epassbase.bean.BaseObserver;
import com.bambooclod.epassbase.bean.EncrypteData;
import com.bambooclod.epassbase.config.HttpConfig;
import com.bambooclod.epassbase.config.InitConfigValue;
import com.bambooclod.epassbase.log.LogUtil;
import com.bambooclod.epassbase.sp.SPUtils;

import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.schedulers.Schedulers;

/**
 * Comment: 短信认证
 *
 * @author Vangelis.Wang in BambooCloud
 * @date 2019-06-14
 * Email:wangpei@bamboocloud.cn
 */
public class SmsAuth {

    private SmsAuth() {
    }

    public static final SmsAuth authRequest = new SmsAuth();

    public static SmsAuth get() {
        return authRequest;
    }

    /**
     * 短信认证（以密码作为认证入口）  -- 绑定
     *
     * @param context        Context
     * @param verCode        验证码
     * @param isSimpleCheck  是否单次认证
     * @param deviceBindType 如果要绑定设备，则需要传递这个参数 1-临时信任 2-永久信任
     * @param callBack       回调
     */
    public void pwdIntoAuthForBind(Context context, String verCode
            , boolean isSimpleCheck, String deviceBindType, AuthCallBack callBack) {

        String session = (String) SPUtils.get(context, InitConfigValue.REQUEST_EP_SESSION, InitConfigValue.DEFAULT);
        if (InitConfigValue.DEFAULT.equals(session)) {
            session = "";
        }

        if (deviceBindType == null) {
            deviceBindType = "1";
        }
        SmsBindData para = new SmsBindData(verCode, deviceBindType);
        AuthRequest.get().doAuth(context, para, session, HttpConfig.AuthType.SMS, true, callBack);
    }

    /**
     * 短信认证（以短信作为认证入口）  -- 绑定
     *
     * @param context        Context
     * @param deviceBindType 如果要绑定设备，则需要传递这个参数 1-临时信任 2-永久信任
     * @param callBack       回调
     */
    public void smsIntoAuthForsBind(Context context
            , String deviceBindType, AuthCallBack callBack) {

        String session = (String) SPUtils.get(context, InitConfigValue.REQUEST_EP_SESSION, InitConfigValue.DEFAULT);
        if (InitConfigValue.DEFAULT.equals(session)) {
            session = "";
        }

        if (deviceBindType == null) {
            deviceBindType = "";
        }
        SmsAuthPara para = new SmsAuthPara(deviceBindType);
        AuthRequest.get().doAuth(context, para, session, HttpConfig.AuthType.SMS, true, callBack);
    }

    /**
     * 短信认证
     *
     * @param context  Context
     * @param phone    电话号码
     * @param verCode  验证码
     * @param callBack 回调
     */
    public void smsAuth(Context context, String phone, String verCode
            , AuthCallBack callBack) {

        String session = (String) SPUtils.get(context, InitConfigValue.REQUEST_EP_SESSION, InitConfigValue.DEFAULT);
        if (InitConfigValue.DEFAULT.equals(session)) {
            session = "";
        }

        SmsAuthPara para = new SmsAuthPara(phone, verCode);
        AuthRequest.get().doAuth(context, para, session, HttpConfig.AuthType.SMS, false, callBack);
    }

    public void singleSmsAuth(Context context, String phone, String verCode, SingalAuthCallBack callBack) {
        SmsAuthPara para = new SmsAuthPara(phone, verCode);
        AuthRequest.get().commonAuth(context, para, HttpConfig.AuthType.SMS, false, callBack);
    }

    /**
     * 获取短信验证码
     *
     * @param context     Context
     * @param epsessionId 会话ID
     * @param mobile      手机号码
     */
    public void sendSms(final Context context, String epsessionId, String mobile
            , final SendSmsCallBack callBack) {
        //是否内容加密
        boolean isEncrypt = SPUtils.isEncrytContent(context);
        //原始请求的Json格式数据
        SendSmsData para = new SendSmsData(epsessionId, mobile);

        //预请求体
        Observer observer;
        Observable observable;

        //Retrofit
        ApiService apiService = EpassBaseSDK.Builder().getAPi(context, ApiService.class);

        if (isEncrypt) {
            String body = JSON.toJSONString(para);
            String authKey = (String) SPUtils.get(context, InitConfigValue.KEY_ENCRYPT, InitConfigValue.DEFAULT);
            Object data = new EncrypteData(EpassBaseSDK.Builder().encryt(body, authKey));

            observable = apiService.commonRequestByEncrypt(ApiService.sendSms, data);

            observer = new BaseEncryptObserver(context) {
                @Override
                protected void onSuccess(Object body) {
                    LogUtil.getInstance().i("请求成功：" + body);
                    if (callBack != null) {
                        callBack.getSmsSuccess(true);
                    }
                }

                @Override
                protected void onCodeError(String code, String message, Object body) {
                    LogUtil.getInstance().d("请求失败：" + code);
                    if (callBack != null) {
                        callBack.error(code, message);
                    }
                }
            };
        } else {
            observable = apiService.commonRequest(ApiService.sendSms, para);

            observer = new BaseObserver<Object>(context) {
                @Override
                protected void onSuccess(Object body) {
                    LogUtil.getInstance().i("请求成功：" + body);
                    if (callBack != null) {
                        callBack.getSmsSuccess(true);
                    }
                }

                @Override
                protected void onCodeError(String code, String message, Object object) {
                    LogUtil.getInstance().d("请求失败：" + code);
                    if (callBack != null) {
                        callBack.error(code, message);
                    }
                }
            };
        }

        observable
                .subscribeOn(Schedulers.io())
                .observeOn(AndroidSchedulers.mainThread())
                .subscribe(observer);
    }
}
