package com.bambooclod.eaccount3.api;

import android.content.Context;
import android.text.TextUtils;
import android.util.Base64;

import com.alibaba.fastjson.JSON;
import com.bambooclod.eaccount3.bean.CommonAuthBaseData;
import com.bambooclod.eaccount3.bean.DoAuthBaseData;
import com.bambooclod.eaccount3.bean.DoAuthResponse;
import com.bambooclod.eaccount3.bean.JwtDecodeData;
import com.bambooclod.eaccount3.callback.AuthCallBack;
import com.bambooclod.eaccount3.callback.AuthCallByBindBack;
import com.bambooclod.eaccount3.callback.SingalAuthCallBack;
import com.bambooclod.eaccount3.http.ApiService;
import com.bambooclod.epassbase.api.EpassBaseSDK;
import com.bambooclod.epassbase.bean.BaseEncryptObserver;
import com.bambooclod.epassbase.bean.BaseObserver;
import com.bambooclod.epassbase.bean.EncrypteData;
import com.bambooclod.epassbase.config.HttpConfig;
import com.bambooclod.epassbase.config.InitConfigValue;
import com.bambooclod.epassbase.log.LogUtil;
import com.bambooclod.epassbase.otp.OtpUtils;
import com.bambooclod.epassbase.sp.SPUtils;

import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.schedulers.Schedulers;

/**
 * Comment: 对外认证请求工具类
 *
 * @author Vangelis.Wang in BambooCloud
 * @date 2019-06-04
 * Email:wangpei@bamboocloud.cn
 */
public class AuthRequest {

    private AuthRequest() {
    }

    public static final AuthRequest authRequest = new AuthRequest();

    public static AuthRequest get() {
        return authRequest;
    }

    /**
     * 统一认证接口
     *
     * @param context      context
     * @param t            具体的请求类型的参数
     * @param epSessionId  会话ID
     * @param callBack     回调
     * @param <T>          泛型为authPara
     * @param isBindDevice 是否为绑定设备的请求
     */
    protected <T> void doAuth(final Context context, T t, String epSessionId, final String authType
            , boolean isBindDevice, final AuthCallBack callBack) {

        //Retrofit
        ApiService apiService = EpassBaseSDK.Builder().getAPi(context, ApiService.class);

        //是否内容加密
        boolean isEncrypt = SPUtils.isEncrytContent(context);
        String appID = (String) SPUtils.get(context, InitConfigValue.APP_ID, InitConfigValue.DEFAULT);

        //统一认证
        DoAuthBaseData<T> doAuth;

        //是否为绑定DoAuth
        if (isBindDevice) {
            //3为绑定
            doAuth = new DoAuthBaseData<>(appID, t, authType, epSessionId, "3", EpassBaseSDK.Builder().getDeviceID(context));
        } else {
            doAuth = new DoAuthBaseData<>(appID, t, authType, epSessionId, EpassBaseSDK.Builder().getDeviceID(context));

        }
        //单次认证
        CommonAuthBaseData<T> commonAuth = new CommonAuthBaseData<>(t, authType);

        //预请求体
        Observer observer;
        Observable observable;

        if (isEncrypt) {
            String body;

            body = JSON.toJSONString(doAuth);
            String authKey = (String) SPUtils.get(context, InitConfigValue.KEY_ENCRYPT, InitConfigValue.DEFAULT);
            Object data = new EncrypteData(EpassBaseSDK.Builder().encryt(body, authKey));
            observable = apiService.commonRequestByEncrypt(ApiService.doAuth, data);

            observer = new BaseEncryptObserver(context) {
                @Override
                protected void onSuccess(Object body) {
                    LogUtil.getInstance().i("请求成功：" + body);
                    authSuccessHandler(context, authType, body, callBack);
                }

                @Override
                protected void onCodeError(String code, String message, Object object) {
                    LogUtil.getInstance().d("请求失败：" + code);

                    //需要绑定设备
                    if ("not.common.device.need.check".equals(code)
                            || "not.common.device.no.check".equals(code)) {

                        DoAuthResponse response = JSON.parseObject(object.toString()
                                , DoAuthResponse.class);

                        //这里存储Session，当没有jwt，而又有Session的时候
                        if (!TextUtils.isEmpty(response.getEpsessionId())) {
                            LogUtil.getInstance().d("存储Session");
                            SPUtils.put(context, InitConfigValue.REQUEST_EP_SESSION, response.getEpsessionId());
                        }
                        if (callBack != null) {
                            //绑定设备
                            callBack.needBindDevice(response.getDevBindExpectAuthType());
                        }
                        //这里是触发了风险
                    } else if ("riskLevel.need.addtional.auth".equals(code)) {
                        callBack.error(code, message);
                        authSuccessHandler(context, authType, object, callBack);
                    } else {
                        if (callBack != null) {
                            callBack.error(code, message);
                        }
                    }
                }

                @Override
                protected void onFailure(Throwable e, boolean isNetWorkError) {
                    super.onFailure(e, isNetWorkError);
                    if (callBack != null) {
                        callBack.error(e.getMessage(), e.getMessage());
                    }
                }
            };
        } else {
            observable = apiService.commonRequest(ApiService.doAuth, doAuth);
            observer = new BaseObserver<Object>(context) {
                @Override
                protected void onSuccess(Object body) {
                    LogUtil.getInstance().i("请求成功：" + body);
                    authSuccessHandler(context, authType, body, callBack);
                }

                @Override
                protected void onCodeError(String code, String message, Object object) {
                    LogUtil.getInstance().d("请求失败：" + code);
                    //需要绑定设备
                    if ("not.common.device.need.check".equals(code)
                            || "not.common.device.no.check".equals(code)) {

                        DoAuthResponse response = JSON.parseObject(object.toString()
                                , DoAuthResponse.class);

                        //这里存储Session，当没有jwt，而又有Session的时候
                        if (!TextUtils.isEmpty(response.getEpsessionId())) {
                            LogUtil.getInstance().d("存储Session");
                            SPUtils.put(context, InitConfigValue.REQUEST_EP_SESSION, response.getEpsessionId());
                        }
                        if (callBack != null) {
                            //绑定设备
                            callBack.needBindDevice(response.getDevBindExpectAuthType());
                        }
                        ////这里是触发了风险
                    } else if ("riskLevel.need.addtional.auth".equals(code)) {
                        callBack.error(code, message);
                        authSuccessHandler(context, authType, object, callBack);
                    } else {
                        if (callBack != null) {
                            callBack.error(code, message);
                        }
                    }
                }

                @Override
                protected void onFailure(Throwable e, boolean isNetWorkError) {
                    super.onFailure(e, isNetWorkError);
                    if (callBack != null) {
                        callBack.error(e.getMessage(), e.getMessage());
                    }
                }
            };
        }


        observable
                .subscribeOn(Schedulers.io())
                .observeOn(AndroidSchedulers.mainThread())
                .subscribe(observer);
    }


    /**
     * 单次认证接口
     *
     * @param context      context
     * @param t            具体的请求类型的参数
     * @param callBack     回调
     * @param <T>          泛型为authPara
     * @param isBindDevice 是否为绑定设备的请求
     */
    protected <T> void commonAuth(final Context context, T t
            , String authType, boolean isBindDevice, final SingalAuthCallBack callBack) {

        //Retrofit
        ApiService apiService = EpassBaseSDK.Builder().getAPi(context, ApiService.class);

        //是否内容加密
        boolean isEncrypt = SPUtils.isEncrytContent(context);
        String appID = (String) SPUtils.get(context, InitConfigValue.APP_ID, InitConfigValue.DEFAULT);

        //单次认证
        CommonAuthBaseData<T> commonAuth = new CommonAuthBaseData<>(t, authType);

        //预请求体
        Observer observer;
        Observable observable;

        if (isEncrypt) {
            String body;
            body = JSON.toJSONString(commonAuth);
            String authKey = (String) SPUtils.get(context, InitConfigValue.KEY_ENCRYPT, InitConfigValue.DEFAULT);
            Object data = new EncrypteData(EpassBaseSDK.Builder().encryt(body, authKey));
            observable = apiService.commonRequestByEncrypt(ApiService.commonAuth, data);

            observer = new BaseEncryptObserver(context) {
                @Override
                protected void onSuccess(Object body) {
                    LogUtil.getInstance().i("请求成功：" + body);
                    singleAuthSuccessHandler(context, body, callBack);
                }

                @Override
                protected void onCodeError(String code, String message, Object object) {
                    LogUtil.getInstance().d("请求失败：" + code);
                    if (callBack != null) {
                        callBack.error(code, message);
                    }
                }

                @Override
                protected void onFailure(Throwable e, boolean isNetWorkError) {
                    super.onFailure(e, isNetWorkError);
                    if (callBack != null) {
                        callBack.error(e.getMessage(), e.getMessage());
                    }
                }
            };
        } else {
            observable = apiService.commonRequest(ApiService.commonAuth, commonAuth);
            observer = new BaseObserver<Object>(context) {
                @Override
                protected void onSuccess(Object body) {
                    LogUtil.getInstance().i("请求成功：" + body);
                    singleAuthSuccessHandler(context, body, callBack);
                }

                @Override
                protected void onCodeError(String code, String message, Object object) {
                    LogUtil.getInstance().d("请求失败：" + code);
                    if (callBack != null) {
                        callBack.error(code, message);
                    }
                }

                @Override
                protected void onFailure(Throwable e, boolean isNetWorkError) {
                    super.onFailure(e, isNetWorkError);
                    if (callBack != null) {
                        callBack.error(e.getMessage(), e.getMessage());
                    }
                }
            };
        }

        observable
                .subscribeOn(Schedulers.io())
                .observeOn(AndroidSchedulers.mainThread())
                .subscribe(observer);
    }

    /**
     * 统一认证接口
     *
     * @param context      context
     * @param t            具体的请求类型的参数
     * @param epSessionId  会话ID
     * @param callBack     回调
     * @param <T>          泛型为authPara
     * @param isBindDevice 是否为绑定设备的请求
     */
    protected <T> void doAuth(final Context context, T t, String epSessionId, final String authType
            , boolean isBindDevice, final AuthCallByBindBack callBack) {

        //Retrofit
        ApiService apiService = EpassBaseSDK.Builder().getAPi(context, ApiService.class);

        //是否内容加密
        boolean isEncrypt = SPUtils.isEncrytContent(context);
        String appID = (String) SPUtils.get(context, InitConfigValue.APP_ID, InitConfigValue.DEFAULT);

        //统一认证
        DoAuthBaseData<T> doAuth;

        //是否为绑定DoAuth
        if (isBindDevice) {
            //3为绑定
            doAuth = new DoAuthBaseData<>(appID, t, authType, epSessionId, "3", EpassBaseSDK.Builder().getDeviceID(context));
        } else {
            doAuth = new DoAuthBaseData<>(appID, t, authType, epSessionId, EpassBaseSDK.Builder().getDeviceID(context));

        }
        //单次认证
        CommonAuthBaseData<T> commonAuth = new CommonAuthBaseData<>(t, authType);

        //预请求体
        Observer observer;
        Observable observable;

        if (isEncrypt) {
            String body;

            body = JSON.toJSONString(doAuth);
            String authKey = (String) SPUtils.get(context, InitConfigValue.KEY_ENCRYPT, InitConfigValue.DEFAULT);
            Object data = new EncrypteData(EpassBaseSDK.Builder().encryt(body, authKey));
            observable = apiService.commonRequestByEncrypt(ApiService.doAuth, data);

            observer = new BaseEncryptObserver(context) {
                @Override
                protected void onSuccess(Object body) {
                    LogUtil.getInstance().i("请求成功：" + body);
                    authSuccessHandler(context, authType, body, callBack);
                }

                @Override
                protected void onCodeError(String code, String message, Object object) {
                    LogUtil.getInstance().d("请求失败：" + code);

                    //需要绑定设备
                    if ("not.common.device.need.check".equals(code)
                            || "not.common.device.no.check".equals(code)) {

                        DoAuthResponse response = JSON.parseObject(object.toString()
                                , DoAuthResponse.class);

                        //这里存储Session，当没有jwt，而又有Session的时候
                        if (!TextUtils.isEmpty(response.getEpsessionId())) {
                            LogUtil.getInstance().d("存储Session");
                            SPUtils.put(context, InitConfigValue.REQUEST_EP_SESSION, response.getEpsessionId());
                        }
                        if (callBack != null) {
                            //绑定设备
                            callBack.needBindDevice(response.getDevBindExpectAuthType(), response.getAddtionalInfo());
                        }
                        //这里是触发了风险
                    } else if ("riskLevel.need.addtional.auth".equals(code)) {
                        callBack.error(code, message);
                        authSuccessHandler(context, authType, object, callBack);
                    } else {
                        if (callBack != null) {
                            callBack.error(code, message);
                        }
                    }
                }

                @Override
                protected void onFailure(Throwable e, boolean isNetWorkError) {
                    super.onFailure(e, isNetWorkError);
                    if (callBack != null) {
                        callBack.error(e.getMessage(), e.getMessage());
                    }
                }
            };
        } else {
            observable = apiService.commonRequest(ApiService.doAuth, doAuth);
            observer = new BaseObserver<Object>(context) {
                @Override
                protected void onSuccess(Object body) {
                    LogUtil.getInstance().i("请求成功：" + body);
                    authSuccessHandler(context, authType, body, callBack);
                }

                @Override
                protected void onCodeError(String code, String message, Object object) {
                    LogUtil.getInstance().d("请求失败：" + code);
                    //需要绑定设备
                    if ("not.common.device.need.check".equals(code)
                            || "not.common.device.no.check".equals(code)) {

                        DoAuthResponse response = JSON.parseObject(object.toString()
                                , DoAuthResponse.class);

                        //这里存储Session，当没有jwt，而又有Session的时候
                        if (!TextUtils.isEmpty(response.getEpsessionId())) {
                            LogUtil.getInstance().d("存储Session");
                            SPUtils.put(context, InitConfigValue.REQUEST_EP_SESSION, response.getEpsessionId());
                        }
                        if (callBack != null) {
                            //绑定设备
                            callBack.needBindDevice(response.getDevBindExpectAuthType(), response.getAddtionalInfo());
                        }
                        ////这里是触发了风险
                    } else if ("riskLevel.need.addtional.auth".equals(code)) {
                        callBack.error(code, message);
                        authSuccessHandler(context, authType, object, callBack);
                    } else {
                        if (callBack != null) {
                            callBack.error(code, message);
                        }
                    }
                }

                @Override
                protected void onFailure(Throwable e, boolean isNetWorkError) {
                    super.onFailure(e, isNetWorkError);
                    if (callBack != null) {
                        callBack.error(e.getMessage(), e.getMessage());
                    }
                }
            };
        }


        observable
                .subscribeOn(Schedulers.io())
                .observeOn(AndroidSchedulers.mainThread())
                .subscribe(observer);
    }

    /**
     * 处理认证成功返回的数据，并回调
     */
    private void authSuccessHandler(Context context, String authType, Object body
            , final AuthCallBack callBack) {
        if (callBack != null) {
            DoAuthResponse response = JSON.parseObject(body.toString(), DoAuthResponse.class);
            //已经拿到jwt了
            if (!"".equals(response.getJwt()) && response.getJwt() != null) {
                LogUtil.getInstance().d("存储JWT，清除SESSION");
                //存储Jwt
                SPUtils.put(context, InitConfigValue.USER_JWT, response.getJwt());
                //拿到Jwt就清除Session
                SPUtils.put(context, InitConfigValue.REQUEST_EP_SESSION, InitConfigValue.DEFAULT);
            } else {
                //这里存储Session，当没有jwt，而又有Session的时候 -> 无效了
                //下一次的认证类型的判断
                if ((!response.getNextAuthType().equals("")) || (!response.getNextAuthType().equals("none"))) {
                    LogUtil.getInstance().d("存储Session");
                    //这里如果是二维码认证，则不需要,因为二维码只有辅助认证
                    if (!authType.equals(HttpConfig.AuthType.QR)) {
                        SPUtils.put(context, InitConfigValue.REQUEST_EP_SESSION, response.getEpsessionId());
                    }
                }
            }

            //服务器没有OTP，也需要覆盖
            LogUtil.getInstance().w("存储OTPKey!");
            OtpUtils.initOtp(context, response.getOptkey());

            callBack.doAuthSuccess(response.getAuthList(), response.getAuthedList());
        }
    }

    /**
     * 处理认证成功返回的数据，并回调
     */
    private void authSuccessHandler(Context context, String authType, Object body
            , final AuthCallByBindBack callBack) {
        if (callBack != null) {
            DoAuthResponse response = JSON.parseObject(body.toString(), DoAuthResponse.class);
            //已经拿到jwt了
            if (!"".equals(response.getJwt()) && response.getJwt() != null) {
                LogUtil.getInstance().d("存储JWT，清除SESSION");
                //存储Jwt
                SPUtils.put(context, InitConfigValue.USER_JWT, response.getJwt());
                //拿到Jwt就清除Session
                SPUtils.put(context, InitConfigValue.REQUEST_EP_SESSION, InitConfigValue.DEFAULT);
            } else {
                //这里存储Session，当没有jwt，而又有Session的时候 -> 无效了
                //下一次的认证类型的判断
                if ((!response.getNextAuthType().equals("")) || (!response.getNextAuthType().equals("none"))) {
                    LogUtil.getInstance().d("存储Session");
                    //这里如果是二维码认证，则不需要,因为二维码只有辅助认证
                    if (!authType.equals(HttpConfig.AuthType.QR)) {
                        SPUtils.put(context, InitConfigValue.REQUEST_EP_SESSION, response.getEpsessionId());
                    }
                }
            }

            //服务器没有OTP，也需要覆盖
            LogUtil.getInstance().w("存储OTPKey!");
            OtpUtils.initOtp(context, response.getOptkey());

            callBack.doAuthSuccess(response.getAuthList(), response.getAuthedList());
        }
    }

    /**
     * 处理认证成功返回的数据，并回调
     */
    private void singleAuthSuccessHandler(Context context, Object body
            , final SingalAuthCallBack callBack) {
        if (callBack != null) {
            callBack.signalAuthSuccess(true);
        }
    }

    /**
     * 从JWT中获取用户信息
     *
     * @param jwt JWT
     * @return JwtDecodeData
     */
    public JwtDecodeData getUserInfoFromJWT(String jwt) {
        //如果请求中含有JWT，表示为登录状态中的请求，则可以通过jwt去获取userinfo
        String[] forma = jwt.split("\\.");
        String jwtContent = new String(Base64.decode(forma[1], Base64.DEFAULT));
        return JSON.parseObject(jwtContent, JwtDecodeData.class);
    }
}
