package com.bambooclod.eaccount3.api;

import android.content.Context;

import com.bambooclod.eaccount3.bean.DoAuthResponse;
import com.bambooclod.eaccount3.bean.VoiceAuthPara;
import com.bambooclod.eaccount3.bean.VoiceAuxAuthPara;
import com.bambooclod.eaccount3.bean.VoiceSignalAuthPara;
import com.bambooclod.eaccount3.callback.AuthCallBack;
import com.bambooclod.eaccount3.callback.AuthCallByBindBack;
import com.bambooclod.eaccount3.callback.AuxAuthCallBack;
import com.bambooclod.eaccount3.callback.SingalAuthCallBack;
import com.bambooclod.epassbase.api.EpassBaseSDK;
import com.bambooclod.epassbase.config.HttpConfig;
import com.bambooclod.epassbase.config.InitConfigValue;
import com.bambooclod.epassbase.sp.SPUtils;

/**
 * Comment: 声纹认证相关
 *
 * @author Vangelis.Wang in BambooCloud
 * @date 2019-06-27
 * Email:wangpei@bamboocloud.cn
 */
public class VoiceAuth {

    private VoiceAuth() {
    }

    public static final VoiceAuth authRequest = new VoiceAuth();

    public static VoiceAuth get() {
        return authRequest;
    }

    /**
     * 声纹首次认证
     * <p>
     * 无用户信息认证
     *
     * @param context  Context
     * @param callBack 回调
     */
    public void voiceAuth(final Context context, String data, String readContent, final AuthCallBack callBack) {
        VoiceAuthPara para = new VoiceAuthPara(EpassBaseSDK.Builder().getDeviceID(context)
                , data);

        AuthRequest.get().doAuth(context, para, ""
                , HttpConfig.AuthType.VOICE, false, new AuthCallBack() {
                    @Override
                    public void doAuthSuccess(String authList, String authedList) {
                        if (callBack != null) {
                            callBack.doAuthSuccess(authList, authedList);
                        }
                    }

                    @Override
                    public void needBindDevice(String authList) {
                        if (callBack != null) {
                            callBack.needBindDevice(authList);
                        }
                    }

                    @Override
                    public void error(String code, String message) {
                        if (callBack != null) {
                            callBack.error(code, message);
                        }
                    }
                });
    }


    /**
     * 声纹单次认证
     *
     * @param context  Context
     * @param callBack 回调
     */
    public void voiceSignalAuth(final Context context, String data, String readContent, final SingalAuthCallBack callBack) {

        String jwt = (String) SPUtils.get(context, InitConfigValue.USER_JWT, InitConfigValue.DEFAULT);
        VoiceSignalAuthPara auxAuthPara;
        //使用JWT获取token
        if (!InitConfigValue.DEFAULT.equals(jwt)) {
            String userID = AuthRequest.get().getUserInfoFromJWT(jwt).getUserid();
            VoiceSignalAuthPara.UserInfoBean userInfoBean =
                    new VoiceSignalAuthPara.UserInfoBean(userID, userID, "", "");
            //如果请求中含有JWT，表示为登录状态中的请求，则可以通过jwt去获取userinfo
            auxAuthPara = new VoiceSignalAuthPara(EpassBaseSDK.Builder().getDeviceID(context), data, userInfoBean);
        } else {
            callBack.error("NoJwt", "当前内部无JWT数据，未登录，需要登录后才能调用此接口");
            return;
        }

        AuthRequest.get().commonAuth(context, auxAuthPara, HttpConfig.AuthType.VOICE
                , false, new SingalAuthCallBack() {

                    @Override
                    public void signalAuthSuccess(boolean isSuccess) {
                        if (callBack != null) {
                            callBack.signalAuthSuccess(isSuccess);
                        }
                    }

                    @Override
                    public void error(String code, String message) {
                        if (callBack != null) {
                            callBack.error(code, message);
                        }
                    }
                });
    }

    /**
     * 声纹认证链认证
     */
    public void voiceLinkAuth(final Context context, String data
            , String readContent, final AuthCallBack callBack) {

        String session = (String) SPUtils.get(context
                , InitConfigValue.REQUEST_EP_SESSION, InitConfigValue.DEFAULT);
        if (InitConfigValue.DEFAULT.equals(session)) {
            session = "";
        }

        VoiceSignalAuthPara auxAuthPara;
        //使用Session获取用户名
        if ("".equals(session) || InitConfigValue.DEFAULT.equals(session) || session == null) {
            callBack.error("NoSession", "无Session参数，发生异常");
            return;
        } else {
            auxAuthPara = new VoiceSignalAuthPara(getUserInfoFromSession(session), data);
        }

        AuthRequest.get().doAuth(context, auxAuthPara, session
                , HttpConfig.AuthType.VOICE, false, new AuthCallBack() {
                    @Override
                    public void doAuthSuccess(String authList, String authedList) {
                        if (callBack != null) {
                            callBack.doAuthSuccess(authList, authedList);
                        }
                    }

                    @Override
                    public void needBindDevice(String authList) {
                        if (callBack != null) {
                            callBack.needBindDevice(authList);
                        }
                    }

                    @Override
                    public void error(String code, String message) {
                        if (callBack != null) {
                            callBack.error(code, message);
                        }
                    }
                });
    }

    /**
     * 声纹认证链认证
     */
    public void voiceLinkAuth(final Context context, String data
            , String readContent, final AuthCallByBindBack callBack) {

        String session = (String) SPUtils.get(context
                , InitConfigValue.REQUEST_EP_SESSION, InitConfigValue.DEFAULT);
        if (InitConfigValue.DEFAULT.equals(session)) {
            session = "";
        }

        VoiceSignalAuthPara auxAuthPara;
        //使用Session获取用户名
        if ("".equals(session) || InitConfigValue.DEFAULT.equals(session) || session == null) {
            callBack.error("NoSession", "无Session参数，发生异常");
            return;
        } else {
            auxAuthPara = new VoiceSignalAuthPara(getUserInfoFromSession(session), data);
        }

        AuthRequest.get().doAuth(context, auxAuthPara, session
                , HttpConfig.AuthType.VOICE, false, new AuthCallByBindBack() {
                    @Override
                    public void doAuthSuccess(String authList, String authedList) {
                        if (callBack != null) {
                            callBack.doAuthSuccess(authList, authedList);
                        }
                    }

                    @Override
                    public void needBindDevice(String authList, DoAuthResponse.AddtionalInfoBean addtionalInfo) {
                        if (callBack != null) {
                            callBack.needBindDevice(authList, addtionalInfo);
                        }
                    }

                    @Override
                    public void error(String code, String message) {
                        if (callBack != null) {
                            callBack.error(code, message);
                        }
                    }
                });
    }

    /**
     * 从Session中获取用户信息
     */
    private String getUserInfoFromSession(String session) {
        //如果请求中含有JWT，表示为登录状态中的请求，则可以通过jwt去获取userinfo
        String[] format = session.split(":");
        return format[1];
    }

    /**
     * 声纹辅助认证
     *
     * @param context  Context
     * @param callBack 回调
     */
    public void voiceAuxAuth(final Context context, String data, String readContent, final AuxAuthCallBack callBack) {
        String jwt = (String) SPUtils.get(context, InitConfigValue.USER_JWT, InitConfigValue.DEFAULT);
        VoiceAuxAuthPara auxAuthPara;
        //使用JWT获取token
        if (!InitConfigValue.DEFAULT.equals(jwt)) {
            String userID = AuthRequest.get().getUserInfoFromJWT(jwt).getUserid();
            VoiceAuxAuthPara.UserInfoBean userInfoBean =
                    new VoiceAuxAuthPara.UserInfoBean(userID, userID, "", "");
            //如果请求中含有JWT，表示为登录状态中的请求，则可以通过jwt去获取userinfo
            auxAuthPara = new VoiceAuxAuthPara(userInfoBean, EpassBaseSDK.Builder().getDeviceID(context)
                    , data);
        } else {
            callBack.error("NoJwt", "当前内部无JWT数据，未登录，需要登录后才能调用此接口");
            return;
        }

        AuthRequest.get().doAuth(context, auxAuthPara, ""
                , HttpConfig.AuthType.VOICE, false, new AuthCallBack() {
                    @Override
                    public void doAuthSuccess(String authList, String authedList) {
                        if (callBack != null) {
                            callBack.auxAuthSuccess();
                        }
                    }

                    @Override
                    public void needBindDevice(String authList) {
                    }

                    @Override
                    public void error(String code, String message) {
                        if (callBack != null) {
                            callBack.error(code, message);
                        }
                    }
                });
    }
}
