package com.bambooclod.eaccount3.bean;

/**
 * Comment: 声纹单次认证
 *
 * @author Vangelis.Wang in BambooCloud
 * @date 2019-06-21
 * Email:wangpei@bamboocloud.cn
 */
public class VoiceSignalAuthPara {

    /**
     * userInfo : {"userId":"aaa","loginName":"aaa","email":"bamboocloud@cn","mobileNum":"13888888888"}
     * deviceFingerprint : A4:50:46:7C:55:C9
     * voiceData : /9j/4QAYRXhpZgAASUkqAAgAAAAAAAAAAAAAAP/sABFEdWNreQABAAQAAAA8AAD/4QMdaHR
     */

    private String loginName;
    private String deviceFingerprint;
    private String voiceData;
    private UserInfoBean userInfo;

    public VoiceSignalAuthPara(String voiceData, UserInfoBean userInfo) {
        this.voiceData = voiceData;
        this.userInfo = userInfo;
    }

    public VoiceSignalAuthPara(String loginName, String voiceData) {
        this.loginName = loginName;
        this.voiceData = voiceData;
    }

    public VoiceSignalAuthPara(String deviceFingerprint, String voiceData, UserInfoBean userInfo) {
        this.deviceFingerprint = deviceFingerprint;
        this.voiceData = voiceData;
        this.userInfo = userInfo;
    }

    public UserInfoBean getUserInfo() {
        return userInfo;
    }

    public void setUserInfo(UserInfoBean userInfo) {
        this.userInfo = userInfo;
    }

    public String getDeviceFingerprint() {
        return deviceFingerprint;
    }

    public void setDeviceFingerprint(String deviceFingerprint) {
        this.deviceFingerprint = deviceFingerprint;
    }

    public String getLoginName() {
        return loginName;
    }

    public void setLoginName(String loginName) {
        this.loginName = loginName;
    }

    public String getVoiceData() {
        return voiceData;
    }

    public void setVoiceData(String voiceData) {
        this.voiceData = voiceData;
    }

    public VoiceSignalAuthPara(String loginName, String deviceFingerprint, String voiceData) {
        this.loginName = loginName;
        this.deviceFingerprint = deviceFingerprint;
        this.voiceData = voiceData;
    }

    public static class UserInfoBean {
        /**
         * userId : aaa
         * loginName : aaa
         * email : bamboocloud@cn
         * mobileNum : 13888888888
         */

        private String userId;
        private String loginName;
        private String email;
        private String mobileNum;

        public String getUserId() {
            return userId;
        }

        public void setUserId(String userId) {
            this.userId = userId;
        }

        public String getLoginName() {
            return loginName;
        }

        public void setLoginName(String loginName) {
            this.loginName = loginName;
        }

        public String getEmail() {
            return email;
        }

        public void setEmail(String email) {
            this.email = email;
        }

        public String getMobileNum() {
            return mobileNum;
        }

        public void setMobileNum(String mobileNum) {
            this.mobileNum = mobileNum;
        }

        public UserInfoBean(String userId, String loginName, String email, String mobileNum) {
            this.userId = userId;
            this.loginName = loginName;
            this.email = email;
            this.mobileNum = mobileNum;
        }

        @Override
        public String toString() {
            return "UserInfoBean{" +
                    "userId='" + userId + '\'' +
                    ", loginName='" + loginName + '\'' +
                    ", email='" + email + '\'' +
                    ", mobileNum='" + mobileNum + '\'' +
                    '}';
        }
    }

    @Override
    public String toString() {
        return "VoiceSignalAuthPara{" +
                "loginName='" + loginName + '\'' +
                ", deviceFingerprint='" + deviceFingerprint + '\'' +
                ", voiceData='" + voiceData + '\'' +
                '}';
    }
}
