package com.bambooclod.eaccount3.api;

import android.content.Context;

import com.bambooclod.eaccount3.bean.DoAuthResponse;
import com.bambooclod.eaccount3.bean.FaceFirstAuthPara;
import com.bambooclod.eaccount3.bean.FaceSignalAuthPara;
import com.bambooclod.eaccount3.callback.AuthCallBack;
import com.bambooclod.eaccount3.callback.AuthCallByBindBack;
import com.bambooclod.eaccount3.callback.AuxAuthCallBack;
import com.bambooclod.eaccount3.callback.SingalAuthCallBack;
import com.bambooclod.epassbase.api.EpassBaseSDK;
import com.bambooclod.epassbase.config.HttpConfig;
import com.bambooclod.epassbase.config.InitConfigValue;
import com.bambooclod.epassbase.sp.SPUtils;

/**
 * Comment: 人脸认证相关
 *
 * @author Vangelis.Wang in BambooCloud
 * @date 2019-06-27
 * Email:wangpei@bamboocloud.cn
 */
public class FaceAuth {

    private FaceAuth() {
    }

    public static final FaceAuth authRequest = new FaceAuth();

    public static FaceAuth get() {
        return authRequest;
    }

    /**
     * 首次人脸认证
     * <p>
     * 使用设备指纹和人脸进行判断
     *
     * @param context  Context
     * @param callBack 回调
     */
    public void firstFaceAuth(final Context context, String data, final AuthCallBack callBack) {
        FaceFirstAuthPara para = new FaceFirstAuthPara(EpassBaseSDK.Builder().getDeviceID(context)
                , data);

        AuthRequest.get().doAuth(context, para, ""
                , HttpConfig.AuthType.FACE, false, new AuthCallBack() {
                    @Override
                    public void doAuthSuccess(String authList, String authedList) {
                        if (callBack != null) {
                            callBack.doAuthSuccess(authList, authedList);
                        }
                    }

                    @Override
                    public void needBindDevice(String authList) {
                        if (callBack != null) {
                            callBack.needBindDevice(authList);
                        }
                    }

                    @Override
                    public void error(String code, String message) {
                        if (callBack != null) {
                            callBack.error(code, message);
                        }
                    }
                });
    }


    /**
     * 人脸单次认证
     * <p>
     *
     * @param context  Context
     * @param callBack 回调
     */
    public void faceSignalAuth(final Context context, String data, final SingalAuthCallBack callBack) {
        String jwt = (String) SPUtils.get(context, InitConfigValue.USER_JWT, InitConfigValue.DEFAULT);
        FaceSignalAuthPara auxAuthPara;
        //使用JWT获取token
        if (!InitConfigValue.DEFAULT.equals(jwt)) {
            String userID = AuthRequest.get().getUserInfoFromJWT(jwt).getUserid();
            FaceSignalAuthPara.UserInfoBean userInfoBean =
                    new FaceSignalAuthPara.UserInfoBean(userID, userID, "", "");
            //如果请求中含有JWT，表示为登录状态中的请求，则可以通过jwt去获取userinfo
            auxAuthPara = new FaceSignalAuthPara(userInfoBean, EpassBaseSDK.Builder().getDeviceID(context)
                    , data);
        } else {
            callBack.error("NoJwt", "当前内部无JWT数据，未登录，需要登录后才能调用此接口");
            return;
        }

        AuthRequest.get().commonAuth(context, auxAuthPara
                , HttpConfig.AuthType.FACE, false, new SingalAuthCallBack() {

                    @Override
                    public void signalAuthSuccess(boolean isSuccess) {
                        if (callBack != null) {
                            callBack.signalAuthSuccess(isSuccess);
                        }
                    }

                    @Override
                    public void error(String code, String message) {
                        if (callBack != null) {
                            callBack.error(code, message);
                        }
                    }
                });
    }

    /**
     * 人脸认证链认证
     */
    public void facaLinkAuth(final Context context, String data, final AuthCallBack callBack) {
        String session = (String) SPUtils.get(context, InitConfigValue.REQUEST_EP_SESSION, InitConfigValue.DEFAULT);
        if (InitConfigValue.DEFAULT.equals(session)) {
            session = "";
        }

        FaceSignalAuthPara auxAuthPara;
        //使用Session获取用户名
        if ("".equals(session) || InitConfigValue.DEFAULT.equals(session) || session == null) {
            callBack.error("NoSession", "无Session参数，发生异常");
            return;
        } else {
            auxAuthPara = new FaceSignalAuthPara(data, getUserInfoFromSession(session));
        }

        AuthRequest.get().doAuth(context, auxAuthPara, session
                , HttpConfig.AuthType.FACE, false, new AuthCallBack() {
                    @Override
                    public void doAuthSuccess(String authList, String authedList) {
                        if (callBack != null) {
                            callBack.doAuthSuccess(authList, authedList);
                        }
                    }

                    @Override
                    public void needBindDevice(String authList) {
                        if (callBack != null) {
                            callBack.needBindDevice(authList);
                        }
                    }

                    @Override
                    public void error(String code, String message) {
                        if (callBack != null) {
                            callBack.error(code, message);
                        }
                    }
                });
    }

    /**
     * 人脸认证链认证
     */
    public void facaLinkAuth(final Context context, String data, final AuthCallByBindBack callBack) {
        String session = (String) SPUtils.get(context, InitConfigValue.REQUEST_EP_SESSION, InitConfigValue.DEFAULT);
        if (InitConfigValue.DEFAULT.equals(session)) {
            session = "";
        }

        FaceSignalAuthPara auxAuthPara;
        //使用Session获取用户名
        if ("".equals(session) || InitConfigValue.DEFAULT.equals(session) || session == null) {
            callBack.error("NoSession", "无Session参数，发生异常");
            return;
        } else {
            auxAuthPara = new FaceSignalAuthPara(data, getUserInfoFromSession(session));
        }

        AuthRequest.get().doAuth(context, auxAuthPara, session
                , HttpConfig.AuthType.FACE, false, new AuthCallByBindBack() {
                    @Override
                    public void doAuthSuccess(String authList, String authedList) {
                        if (callBack != null) {
                            callBack.doAuthSuccess(authList, authedList);
                        }
                    }

                    @Override
                    public void needBindDevice(String authList, DoAuthResponse.AddtionalInfoBean addtionalInfo) {
                        if (callBack != null) {
                            callBack.needBindDevice(authList, addtionalInfo);
                        }
                    }

                    @Override
                    public void error(String code, String message) {
                        if (callBack != null) {
                            callBack.error(code, message);
                        }
                    }
                });
    }

    /**
     * 从Session中获取用户信息
     */
    private String getUserInfoFromSession(String session) {
        //如果请求中含有JWT，表示为登录状态中的请求，则可以通过jwt去获取userinfo
        String[] format = session.split(":");
        return format[1];
    }

    /**
     * 人脸辅助认证
     */
    public void faceAuxAuth(final Context context, String data, final AuxAuthCallBack callBack) {
        String jwt = (String) SPUtils.get(context, InitConfigValue.USER_JWT, InitConfigValue.DEFAULT);
        FaceSignalAuthPara auxAuthPara;
        //使用JWT获取token
        if (!InitConfigValue.DEFAULT.equals(jwt)) {
            String userID = AuthRequest.get().getUserInfoFromJWT(jwt).getUserid();
            FaceSignalAuthPara.UserInfoBean userInfoBean =
                    new FaceSignalAuthPara.UserInfoBean(userID, userID, "", "");
            //如果请求中含有JWT，表示为登录状态中的请求，则可以通过jwt去获取userinfo
            auxAuthPara = new FaceSignalAuthPara(userInfoBean, EpassBaseSDK.Builder().getDeviceID(context)
                    , data);
        } else {
            callBack.error("NoJwt", "当前内部无JWT数据，未登录，需要登录后才能调用此接口");
            return;
        }

        AuthRequest.get().doAuth(context, auxAuthPara, ""
                , HttpConfig.AuthType.FACE, false, new AuthCallBack() {
                    @Override
                    public void doAuthSuccess(String authList, String authedList) {
                        if (callBack != null) {
                            callBack.auxAuthSuccess();
                        }
                    }

                    @Override
                    public void needBindDevice(String authList) {
                    }

                    @Override
                    public void error(String code, String message) {
                        if (callBack != null) {
                            callBack.error(code, message);
                        }
                    }
                });
    }
}
