package com.bambooclod.eaccount3.api;

import android.content.Context;
import android.util.Base64;
import android.widget.Toast;

import com.alibaba.fastjson.JSON;
import com.bambooclod.eaccount3.bean.GestureAuthPara;
import com.bambooclod.eaccount3.bean.JwtDecodeData;
import com.bambooclod.eaccount3.callback.AuthCallBack;
import com.bambooclod.eaccount3.callback.AuxAuthCallBack;
import com.bambooclod.eaccount3.callback.SingalAuthCallBack;
import com.bambooclod.epassbase.config.HttpConfig;
import com.bambooclod.epassbase.config.InitConfigValue;
import com.bambooclod.epassbase.sp.SPUtils;

/**
 * Comment: 手势认证
 *
 * @author Vangelis.Wang in BambooCloud
 * @date 2019-06-14
 * Email:wangpei@bamboocloud.cn
 */
public class GestureAuth {

    private GestureAuth() {
    }

    public static final GestureAuth authRequest = new GestureAuth();

    public static GestureAuth get() {
        return authRequest;
    }

    /**
     * 手势单次认证
     */
    public void signalGestureAuth(Context context, String gesture
            , final SingalAuthCallBack callBack) {
        singleAuthGesture(context, gesture, callBack);
    }

    /**
     * 手势认证链认证
     */
    public void linkGestureAuth(Context context, String gesture
            , final AuthCallBack callBack) {

        String session = (String) SPUtils.get(context, InitConfigValue.REQUEST_EP_SESSION, InitConfigValue.DEFAULT);
        if (InitConfigValue.DEFAULT.equals(session)) {
            session = "";
        }

        linkAuthGesture(context, session, gesture, callBack);
    }

    /**
     * 从JWT中获取用户信息
     *
     * @param jwt JWT
     * @return JwtDecodeData
     */
    private JwtDecodeData getUserInfoFromJWT(String jwt) {
        //如果请求中含有JWT，表示为登录状态中的请求，则可以通过jwt去获取userinfo
        String[] forma = jwt.split("\\.");
        String jwtContent = new String(Base64.decode(forma[1], Base64.DEFAULT));
        return JSON.parseObject(jwtContent, JwtDecodeData.class);
    }

    /**
     * 手势辅助认证
     */
    public void auxGestureAuth(Context context, String gesture, final AuxAuthCallBack callBack) {
        String jwt = (String) SPUtils.get(context, InitConfigValue.USER_JWT, InitConfigValue.DEFAULT);
        GestureAuthPara auxAuthPara;
        //使用JWT获取token
        if (!InitConfigValue.DEFAULT.equals(jwt)) {
            String userID = getUserInfoFromJWT(jwt).getUserid();
            GestureAuthPara.UserInfoBean userInfoBean =
                    new GestureAuthPara.UserInfoBean(userID, userID, "");
            //如果请求中含有JWT，表示为登录状态中的请求，则可以通过jwt去获取userinfo
            auxAuthPara = new GestureAuthPara(userInfoBean, gesture);
        } else {
            callBack.error("NoJwt","当前内部无JWT数据，未登录，需要登录后才能调用此接口");
            return;
        }

        AuthRequest.get().doAuth(context, auxAuthPara, ""
                , HttpConfig.AuthType.GESTURE, false, new AuthCallBack() {
                    @Override
                    public void doAuthSuccess(String authList, String authedList) {
                        if (callBack != null) {
                            callBack.auxAuthSuccess();
                        }
                    }

                    @Override
                    public void needBindDevice(String authList) {
                    }

                    @Override
                    public void error(String code, String message) {
                        if (callBack != null) {
                            callBack.error(code, message);
                        }
                    }
                });
    }

    /**
     * 从Session中获取用户信息
     */
    private String getUserInfoFromSession(String session) {
        //如果请求中含有JWT，表示为登录状态中的请求，则可以通过jwt去获取userinfo
        String[] format = session.split(":");
        return format[1];
    }


    /**
     * 单次认证
     */
    private void singleAuthGesture(Context context, String gesture
            , final SingalAuthCallBack mDoOrCommonAuthCallBack) {

        //支持离线认证模式
        final String authType = (String) SPUtils.get(context, InitConfigValue.GLOBAL_AUTH_TYPE
                , InitConfigValue.DEFAULT);

        //在线模式
        if (InitConfigValue.DEFAULT.equals(authType) || HttpConfig.GLOBAL_AUTH_TYPE_ONLINE.equals(authType)) {
            String jwt = (String) SPUtils.get(context, InitConfigValue.USER_JWT, InitConfigValue.DEFAULT);
            GestureAuthPara.UserInfoBean userInfoBean;
            GestureAuthPara gestureAuthPara;

            if (InitConfigValue.DEFAULT.equals(jwt)) {
                //单次和认证链都要jwt
                mDoOrCommonAuthCallBack.error("NoJwt","当前内部无JWT数据，未登录，需要登录后才能调用此接口");
                return;
            } else {
                //如果请求中含有JWT，表示为登录状态中的请求，则可以通过jwt去获取userinfo
                String[] forma = jwt.split("\\.");
                String jwtContent = new String(Base64.decode(forma[1], Base64.DEFAULT));
                JwtDecodeData decodeData = JSON.parseObject(jwtContent, JwtDecodeData.class);

                //单次
                userInfoBean =
                        new GestureAuthPara.UserInfoBean(decodeData.getUserid()
                                , decodeData.getUserid(), "");

                gestureAuthPara = new GestureAuthPara(userInfoBean, gesture);
            }

            AuthRequest.get().commonAuth(context, gestureAuthPara
                    , HttpConfig.AuthType.GESTURE, false, new SingalAuthCallBack() {
                        @Override
                        public void signalAuthSuccess(boolean isSuccess) {
                            mDoOrCommonAuthCallBack.signalAuthSuccess(isSuccess);
                        }

                        @Override
                        public void error(String code, String message) {
                            mDoOrCommonAuthCallBack.error(code, message);
                        }
                    });
        } else {
            //离线模式，自己存储手势密码
            String localUserName = (String) SPUtils.get(context, InitConfigValue.OFFLINE_USER_NAME, InitConfigValue.DEFAULT);
            if (InitConfigValue.DEFAULT.equals(localUserName)) {
                if (mDoOrCommonAuthCallBack != null) {
                    mDoOrCommonAuthCallBack.error("-1", "没有设置离线用户名");
                }
            } else {
                //Key为：离线用户名+固定值
                String localGesture = (String) SPUtils.get(context, localUserName + InitConfigValue.OFFLINE_GESTURE_PASSWORD, InitConfigValue.DEFAULT);
                if (gesture.equals(localGesture)) {
                    if (mDoOrCommonAuthCallBack != null) {
                        mDoOrCommonAuthCallBack.signalAuthSuccess(true);
                    }
                } else {
                    if (mDoOrCommonAuthCallBack != null) {
                        mDoOrCommonAuthCallBack.signalAuthSuccess(false);
                    }
                }
            }
        }
    }

    /**
     * 认证链认证
     */
    private void linkAuthGesture(Context context, String session, String gesture
            , final AuthCallBack mAuthCallBack) {
        String jwt = (String) SPUtils.get(context, InitConfigValue.USER_JWT, InitConfigValue.DEFAULT);
        GestureAuthPara.UserInfoBean userInfoBean;
        GestureAuthPara gestureAuthPara;

        //使用Session获取用户名
        if ("".equals(session) || InitConfigValue.DEFAULT.equals(session) || session == null) {
            mAuthCallBack.error("NoSession","无Session参数，发生异常");
            return;
        } else {
            gestureAuthPara = new GestureAuthPara(gesture, getUserInfoFromSession(session));
        }

        AuthRequest.get().doAuth(context, gestureAuthPara, session
                , HttpConfig.AuthType.GESTURE, false, new AuthCallBack() {
                    @Override
                    public void doAuthSuccess(String authList, String authedList) {
                        mAuthCallBack.doAuthSuccess(authList, authedList);
                    }

                    @Override
                    public void needBindDevice(String authList) {
                        mAuthCallBack.needBindDevice(authList);
                    }

                    @Override
                    public void error(String code, String message) {
                        mAuthCallBack.error(code, message);
                    }
                });
    }

}
